/*
 * Decompiled with CFR 0.152.
 */
package jef.cpu;

import jef.cpu.Cpu;
import jef.cpu.Z80debug;
import jef.cpuboard.CpuBoard;

public final class Z80
implements Cpu,
Z80debug {
    static final boolean DEBUG = false;
    public int A;
    public int F;
    public int B;
    public int C;
    public int D;
    public int E;
    public int H;
    public int L;
    public int I;
    public int R;
    public int R2;
    public int A1;
    public int F1;
    public int B1;
    public int C1;
    public int D1;
    public int E1;
    public int H1;
    public int L1;
    public int PC;
    public int SP = 65536;
    public int IX;
    public int IY;
    public int IXYd = 0;
    private CpuBoard ram;
    public boolean state_HALT = false;
    private boolean state_INIT = false;
    public int IM = 0;
    public boolean IFF0 = false;
    public boolean IFF1 = false;
    public int I_Vector = 0;
    public boolean IRQ = false;
    public boolean NMI = false;
    private boolean goingToirq = false;
    public int cycle = 0;
    private int instruction = 0;
    private int tmp;
    private int tmp1;
    private int tmp2;
    private int tmp3;
    private int PPC = 0;
    private static final int[] bitSet = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final int[] bitRes = new int[]{254, 253, 251, 247, 239, 223, 191, 127};
    int debugLevel = 0;
    static int debugBreakPoint = 0;
    static boolean debugEnabled = false;
    boolean startSlice = true;
    private static final boolean[] parity = new boolean[256];
    private static final int[] SZ = new int[256];
    private static final int[] SZ_BIT = new int[256];
    private static final int[] SZP = new int[256];
    private static final int[] SZHV_inc = new int[256];
    private static final int[] SZHV_dec = new int[256];
    private static final int[] SZHVC_Add = new int[131072];
    private static final int[] SZHVC_sub = new int[131072];
    private static final int SF = 128;
    private static final int ZF = 64;
    private static final int YF = 32;
    private static final int HF = 16;
    private static final int XF = 8;
    private static final int VF = 4;
    private static final int PF = 4;
    private static final int NF = 2;
    private static final int CF = 1;
    private String tag;

    static {
        int p = 0;
        int i = 0;
        while (i < 256) {
            boolean bp = true;
            int j = 0;
            while (j < 8) {
                if ((i & 1 << j) != 0) {
                    bp = !bp;
                }
                ++j;
            }
            Z80.parity[i] = bp;
            p = 0;
            if ((i & 1) != 0) {
                ++p;
            }
            if ((i & 2) != 0) {
                ++p;
            }
            if ((i & 4) != 0) {
                ++p;
            }
            if ((i & 8) != 0) {
                ++p;
            }
            if ((i & 0x10) != 0) {
                ++p;
            }
            if ((i & 0x20) != 0) {
                ++p;
            }
            if ((i & 0x40) != 0) {
                ++p;
            }
            if ((i & 0x80) != 0) {
                ++p;
            }
            Z80.SZ[i] = i != 0 ? i & 0x80 : 64;
            int n = i;
            SZ[n] = SZ[n] | i & 0x28;
            Z80.SZ_BIT[i] = i != 0 ? i & 0x80 : 68;
            int n2 = i;
            SZ_BIT[n2] = SZ_BIT[n2] | i & 0x28;
            Z80.SZP[i] = SZ[i] | ((p & 1) != 0 ? 0 : 4);
            Z80.SZHV_inc[i] = SZ[i];
            if (i == 128) {
                int n3 = i;
                SZHV_inc[n3] = SZHV_inc[n3] | 4;
            }
            if ((i & 0xF) == 0) {
                int n4 = i;
                SZHV_inc[n4] = SZHV_inc[n4] | 0x10;
            }
            Z80.SZHV_dec[i] = SZ[i] | 2;
            if (i == 127) {
                int n5 = i;
                SZHV_dec[n5] = SZHV_dec[n5] | 4;
            }
            if ((i & 0xF) == 15) {
                int n6 = i;
                SZHV_dec[n6] = SZHV_dec[n6] | 0x10;
            }
            ++i;
        }
        int padd = 0;
        int padc = 65536;
        int psub = 0;
        int psbc = 65536;
        int oldval = 0;
        while (oldval < 256) {
            int newval = 0;
            while (newval < 256) {
                int val = newval - oldval;
                Z80.SZHVC_Add[padd] = newval != 0 ? ((newval & 0x80) != 0 ? 128 : 0) : 64;
                int n = padd;
                SZHVC_Add[n] = SZHVC_Add[n] | newval & 0x28;
                if ((newval & 0xF) < (oldval & 0xF)) {
                    int n7 = padd;
                    SZHVC_Add[n7] = SZHVC_Add[n7] | 0x10;
                }
                if (newval < oldval) {
                    int n8 = padd;
                    SZHVC_Add[n8] = SZHVC_Add[n8] | 1;
                }
                if (((val ^ oldval ^ 0x80) & (val ^ newval) & 0x80) != 0) {
                    int n9 = padd;
                    SZHVC_Add[n9] = SZHVC_Add[n9] | 4;
                }
                ++padd;
                val = newval - oldval - 1;
                Z80.SZHVC_Add[padc] = newval != 0 ? ((newval & 0x80) != 0 ? 128 : 0) : 64;
                int n10 = padc;
                SZHVC_Add[n10] = SZHVC_Add[n10] | newval & 0x28;
                if ((newval & 0xF) <= (oldval & 0xF)) {
                    int n11 = padc;
                    SZHVC_Add[n11] = SZHVC_Add[n11] | 0x10;
                }
                if (newval <= oldval) {
                    int n12 = padc;
                    SZHVC_Add[n12] = SZHVC_Add[n12] | 1;
                }
                if (((val ^ oldval ^ 0x80) & (val ^ newval) & 0x80) != 0) {
                    int n13 = padc;
                    SZHVC_Add[n13] = SZHVC_Add[n13] | 4;
                }
                ++padc;
                val = oldval - newval;
                Z80.SZHVC_sub[psub] = newval != 0 ? ((newval & 0x80) != 0 ? 130 : 2) : 66;
                int n14 = psub;
                SZHVC_sub[n14] = SZHVC_sub[n14] | newval & 0x28;
                if ((newval & 0xF) > (oldval & 0xF)) {
                    int n15 = psub;
                    SZHVC_sub[n15] = SZHVC_sub[n15] | 0x10;
                }
                if (newval > oldval) {
                    int n16 = psub;
                    SZHVC_sub[n16] = SZHVC_sub[n16] | 1;
                }
                if (((val ^ oldval) & (oldval ^ newval) & 0x80) != 0) {
                    int n17 = psub;
                    SZHVC_sub[n17] = SZHVC_sub[n17] | 4;
                }
                ++psub;
                val = oldval - newval - 1;
                Z80.SZHVC_sub[psbc] = newval != 0 ? ((newval & 0x80) != 0 ? 130 : 2) : 66;
                int n18 = psbc;
                SZHVC_sub[n18] = SZHVC_sub[n18] | newval & 0x28;
                if ((newval & 0xF) >= (oldval & 0xF)) {
                    int n19 = psbc;
                    SZHVC_sub[n19] = SZHVC_sub[n19] | 0x10;
                }
                if (newval >= oldval) {
                    int n20 = psbc;
                    SZHVC_sub[n20] = SZHVC_sub[n20] | 1;
                }
                if (((val ^ oldval) & (oldval ^ newval) & 0x80) != 0) {
                    int n21 = psbc;
                    SZHVC_sub[n21] = SZHVC_sub[n21] | 4;
                }
                ++psbc;
                ++newval;
            }
            ++oldval;
        }
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean init(CpuBoard ram, int debug) {
        this.ram = ram;
        return true;
    }

    public final long getInstruction() {
        return this.instruction;
    }

    public final void interrupt(int type, boolean irq) {
        if (type == 1) {
            this.nmi();
        } else if (type == 0) {
            this.irq();
        }
    }

    public final int getPC() {
        return this.PC;
    }

    public final void setDebug(int debugLevel) {
    }

    public final int getDebug() {
        return this.debugLevel;
    }

    public final void setProperty(int property, int value) {
        if (property == 0) {
            this.I_Vector = value;
        }
    }

    public final void irq() {
        this.IRQ = true;
    }

    public final void nmi() {
        this.NMI = true;
    }

    public final void reset() {
        this.SP = 65536;
        this.PC = 0;
        this.A = 0;
        this.F = 0;
        this.B = 0;
        this.C = 0;
        this.D = 0;
        this.E = 0;
        this.H = 0;
        this.L = 0;
        this.I = 0;
        this.R = 0;
        this.IX = 65535;
        this.IY = 65535;
        this.cycle = 0;
        this.A1 = 0;
        this.F1 = 0;
        this.B1 = 0;
        this.C1 = 0;
        this.D1 = 0;
        this.E1 = 0;
        this.H1 = 0;
        this.L1 = 0;
    }

    public final int getCyclesLeft() {
        return this.cycle;
    }

    public final void exec(int cycles) {
        this.cycle += cycles;
        this.cycle = this.checkInterrupt(this.cycle);
        while (this.cycle > 0) {
            this.instruction = this.ram.read8opc(this.PC);
            this.PPC = this.PC;
            this.PC = this.PC + 1 & 0xFFFF;
            ++this.R;
            switch (this.instruction) {
                case 0: {
                    this.nop();
                    break;
                }
                case 1: {
                    this.ld_BC_nn();
                    break;
                }
                case 2: {
                    this.ld_BCi_A();
                    break;
                }
                case 3: {
                    this.inc_BC();
                    break;
                }
                case 4: {
                    this.inc_B();
                    break;
                }
                case 5: {
                    this.dec_B();
                    break;
                }
                case 6: {
                    this.ld_B_n();
                    break;
                }
                case 7: {
                    this.rlca();
                    break;
                }
                case 8: {
                    this.ex_AF_AF();
                    break;
                }
                case 9: {
                    this.add_HL_BC();
                    break;
                }
                case 10: {
                    this.ld_A_BCi();
                    break;
                }
                case 11: {
                    this.dec_BC();
                    break;
                }
                case 12: {
                    this.inc_C();
                    break;
                }
                case 13: {
                    this.dec_C();
                    break;
                }
                case 14: {
                    this.ld_C_n();
                    break;
                }
                case 15: {
                    this.rrca();
                    break;
                }
                case 16: {
                    this.djnz_n();
                    break;
                }
                case 17: {
                    this.ld_DE_nn();
                    break;
                }
                case 18: {
                    this.ld_DEi_A();
                    break;
                }
                case 19: {
                    this.inc_DE();
                    break;
                }
                case 20: {
                    this.inc_D();
                    break;
                }
                case 21: {
                    this.dec_D();
                    break;
                }
                case 22: {
                    this.ld_D_n();
                    break;
                }
                case 23: {
                    this.rla();
                    break;
                }
                case 24: {
                    this.jr_e();
                    break;
                }
                case 25: {
                    this.add_HL_DE();
                    break;
                }
                case 26: {
                    this.ld_A_DEi();
                    break;
                }
                case 27: {
                    this.dec_DE();
                    break;
                }
                case 28: {
                    this.inc_E();
                    break;
                }
                case 29: {
                    this.dec_E();
                    break;
                }
                case 30: {
                    this.ld_E_n();
                    break;
                }
                case 31: {
                    this.rra();
                    break;
                }
                case 32: {
                    this.jr_NZ_e();
                    break;
                }
                case 33: {
                    this.ld_HL_nn();
                    break;
                }
                case 34: {
                    this.ld_ni_HL();
                    break;
                }
                case 35: {
                    this.inc_HL();
                    break;
                }
                case 36: {
                    this.inc_H();
                    break;
                }
                case 37: {
                    this.dec_H();
                    break;
                }
                case 38: {
                    this.ld_H_n();
                    break;
                }
                case 39: {
                    this.daa();
                    break;
                }
                case 40: {
                    this.jr_Z_e();
                    break;
                }
                case 41: {
                    this.add_HL_HL();
                    break;
                }
                case 42: {
                    this.ld_HL_ni();
                    break;
                }
                case 43: {
                    this.dec_HL();
                    break;
                }
                case 44: {
                    this.inc_L();
                    break;
                }
                case 45: {
                    this.dec_L();
                    break;
                }
                case 46: {
                    this.ld_L_n();
                    break;
                }
                case 47: {
                    this.cpl();
                    break;
                }
                case 48: {
                    this.jr_NC_e();
                    break;
                }
                case 49: {
                    this.ld_SP_nn();
                    break;
                }
                case 50: {
                    this.ld_ni_A();
                    break;
                }
                case 51: {
                    this.inc_SP();
                    break;
                }
                case 52: {
                    this.inc_HLi();
                    break;
                }
                case 53: {
                    this.dec_HLi();
                    break;
                }
                case 54: {
                    this.ld_HLi_n();
                    break;
                }
                case 55: {
                    this.scf();
                    break;
                }
                case 56: {
                    this.jr_C_e();
                    break;
                }
                case 57: {
                    this.add_HL_SP();
                    break;
                }
                case 58: {
                    this.ld_A_ni();
                    break;
                }
                case 59: {
                    this.dec_SP();
                    break;
                }
                case 60: {
                    this.inc_A();
                    break;
                }
                case 61: {
                    this.dec_A();
                    break;
                }
                case 62: {
                    this.ld_A_n();
                    break;
                }
                case 63: {
                    this.ccf();
                    break;
                }
                case 64: {
                    this.nop();
                    break;
                }
                case 65: {
                    this.ld_B(this.C, 4);
                    break;
                }
                case 66: {
                    this.ld_B(this.D, 4);
                    break;
                }
                case 67: {
                    this.ld_B(this.E, 4);
                    break;
                }
                case 68: {
                    this.ld_B(this.H, 4);
                    break;
                }
                case 69: {
                    this.ld_B(this.L, 4);
                    break;
                }
                case 70: {
                    this.ld_B(this.HLi(), 7);
                    break;
                }
                case 71: {
                    this.ld_B(this.A, 4);
                    break;
                }
                case 72: {
                    this.ld_C(this.B, 4);
                    break;
                }
                case 73: {
                    this.nop();
                    break;
                }
                case 74: {
                    this.ld_C(this.D, 4);
                    break;
                }
                case 75: {
                    this.ld_C(this.E, 4);
                    break;
                }
                case 76: {
                    this.ld_C(this.H, 4);
                    break;
                }
                case 77: {
                    this.ld_C(this.L, 4);
                    break;
                }
                case 78: {
                    this.ld_C(this.HLi(), 7);
                    break;
                }
                case 79: {
                    this.ld_C(this.A, 4);
                    break;
                }
                case 80: {
                    this.ld_D(this.B, 4);
                    break;
                }
                case 81: {
                    this.ld_D(this.C, 4);
                    break;
                }
                case 82: {
                    this.nop();
                    break;
                }
                case 83: {
                    this.ld_D(this.E, 4);
                    break;
                }
                case 84: {
                    this.ld_D(this.H, 4);
                    break;
                }
                case 85: {
                    this.ld_D(this.L, 4);
                    break;
                }
                case 86: {
                    this.ld_D(this.HLi(), 7);
                    break;
                }
                case 87: {
                    this.ld_D(this.A, 4);
                    break;
                }
                case 88: {
                    this.ld_E(this.B, 4);
                    break;
                }
                case 89: {
                    this.ld_E(this.C, 4);
                    break;
                }
                case 90: {
                    this.ld_E(this.D, 4);
                    break;
                }
                case 91: {
                    this.nop();
                    break;
                }
                case 92: {
                    this.ld_E(this.H, 4);
                    break;
                }
                case 93: {
                    this.ld_E(this.L, 4);
                    break;
                }
                case 94: {
                    this.ld_E(this.HLi(), 7);
                    break;
                }
                case 95: {
                    this.ld_E(this.A, 4);
                    break;
                }
                case 96: {
                    this.ld_H(this.B, 4);
                    break;
                }
                case 97: {
                    this.ld_H(this.C, 4);
                    break;
                }
                case 98: {
                    this.ld_H(this.D, 4);
                    break;
                }
                case 99: {
                    this.ld_H(this.E, 4);
                    break;
                }
                case 100: {
                    this.nop();
                    break;
                }
                case 101: {
                    this.ld_H(this.L, 4);
                    break;
                }
                case 102: {
                    this.ld_H(this.HLi(), 7);
                    break;
                }
                case 103: {
                    this.ld_H(this.A, 4);
                    break;
                }
                case 104: {
                    this.ld_L(this.B, 4);
                    break;
                }
                case 105: {
                    this.ld_L(this.C, 4);
                    break;
                }
                case 106: {
                    this.ld_L(this.D, 4);
                    break;
                }
                case 107: {
                    this.ld_L(this.E, 4);
                    break;
                }
                case 108: {
                    this.ld_L(this.H, 4);
                    break;
                }
                case 109: {
                    this.nop();
                    break;
                }
                case 110: {
                    this.ld_L(this.HLi(), 7);
                    break;
                }
                case 111: {
                    this.ld_L(this.A, 4);
                    break;
                }
                case 112: {
                    this.ld_HLi(this.B, 7);
                    break;
                }
                case 113: {
                    this.ld_HLi(this.C, 7);
                    break;
                }
                case 114: {
                    this.ld_HLi(this.D, 7);
                    break;
                }
                case 115: {
                    this.ld_HLi(this.E, 7);
                    break;
                }
                case 116: {
                    this.ld_HLi(this.H, 7);
                    break;
                }
                case 117: {
                    this.ld_HLi(this.L, 7);
                    break;
                }
                case 118: {
                    this.halt();
                    break;
                }
                case 119: {
                    this.ld_HLi(this.A, 7);
                    break;
                }
                case 120: {
                    this.ld_A(this.B, 4);
                    break;
                }
                case 121: {
                    this.ld_A(this.C, 4);
                    break;
                }
                case 122: {
                    this.ld_A(this.D, 4);
                    break;
                }
                case 123: {
                    this.ld_A(this.E, 4);
                    break;
                }
                case 124: {
                    this.ld_A(this.H, 4);
                    break;
                }
                case 125: {
                    this.ld_A(this.L, 4);
                    break;
                }
                case 126: {
                    this.ld_A(this.HLi(), 7);
                    break;
                }
                case 127: {
                    this.nop();
                    break;
                }
                case 128: {
                    this.add_A(this.B, 4);
                    break;
                }
                case 129: {
                    this.add_A(this.C, 4);
                    break;
                }
                case 130: {
                    this.add_A(this.D, 4);
                    break;
                }
                case 131: {
                    this.add_A(this.E, 4);
                    break;
                }
                case 132: {
                    this.add_A(this.H, 4);
                    break;
                }
                case 133: {
                    this.add_A(this.L, 4);
                    break;
                }
                case 134: {
                    this.add_A(this.HLi(), 7);
                    break;
                }
                case 135: {
                    this.add_A(this.A, 4);
                    break;
                }
                case 136: {
                    this.adc_A(this.B, 4);
                    break;
                }
                case 137: {
                    this.adc_A(this.C, 4);
                    break;
                }
                case 138: {
                    this.adc_A(this.D, 4);
                    break;
                }
                case 139: {
                    this.adc_A(this.E, 4);
                    break;
                }
                case 140: {
                    this.adc_A(this.H, 4);
                    break;
                }
                case 141: {
                    this.adc_A(this.L, 4);
                    break;
                }
                case 142: {
                    this.adc_A(this.HLi(), 7);
                    break;
                }
                case 143: {
                    this.adc_A(this.A, 4);
                    break;
                }
                case 144: {
                    this.sub_A(this.B, 4);
                    break;
                }
                case 145: {
                    this.sub_A(this.C, 4);
                    break;
                }
                case 146: {
                    this.sub_A(this.D, 4);
                    break;
                }
                case 147: {
                    this.sub_A(this.E, 4);
                    break;
                }
                case 148: {
                    this.sub_A(this.H, 4);
                    break;
                }
                case 149: {
                    this.sub_A(this.L, 4);
                    break;
                }
                case 150: {
                    this.sub_A(this.HLi(), 7);
                    break;
                }
                case 151: {
                    this.sub_A(this.A, 4);
                    break;
                }
                case 152: {
                    this.sbc_A(this.B, 4);
                    break;
                }
                case 153: {
                    this.sbc_A(this.C, 4);
                    break;
                }
                case 154: {
                    this.sbc_A(this.D, 4);
                    break;
                }
                case 155: {
                    this.sbc_A(this.E, 4);
                    break;
                }
                case 156: {
                    this.sbc_A(this.H, 4);
                    break;
                }
                case 157: {
                    this.sbc_A(this.L, 4);
                    break;
                }
                case 158: {
                    this.sbc_A(this.HLi(), 7);
                    break;
                }
                case 159: {
                    this.sbc_A(this.A, 4);
                    break;
                }
                case 160: {
                    this.and_A(this.B, 4);
                    break;
                }
                case 161: {
                    this.and_A(this.C, 4);
                    break;
                }
                case 162: {
                    this.and_A(this.D, 4);
                    break;
                }
                case 163: {
                    this.and_A(this.E, 4);
                    break;
                }
                case 164: {
                    this.and_A(this.H, 4);
                    break;
                }
                case 165: {
                    this.and_A(this.L, 4);
                    break;
                }
                case 166: {
                    this.and_A(this.HLi(), 7);
                    break;
                }
                case 167: {
                    this.and_A(this.A, 4);
                    break;
                }
                case 168: {
                    this.xor_A(this.B, 4);
                    break;
                }
                case 169: {
                    this.xor_A(this.C, 4);
                    break;
                }
                case 170: {
                    this.xor_A(this.D, 4);
                    break;
                }
                case 171: {
                    this.xor_A(this.E, 4);
                    break;
                }
                case 172: {
                    this.xor_A(this.H, 4);
                    break;
                }
                case 173: {
                    this.xor_A(this.L, 4);
                    break;
                }
                case 174: {
                    this.xor_A(this.HLi(), 7);
                    break;
                }
                case 175: {
                    this.xor_A(this.A, 4);
                    break;
                }
                case 176: {
                    this.or_A(this.B, 4);
                    break;
                }
                case 177: {
                    this.or_A(this.C, 4);
                    break;
                }
                case 178: {
                    this.or_A(this.D, 4);
                    break;
                }
                case 179: {
                    this.or_A(this.E, 4);
                    break;
                }
                case 180: {
                    this.or_A(this.H, 4);
                    break;
                }
                case 181: {
                    this.or_A(this.L, 4);
                    break;
                }
                case 182: {
                    this.or_A(this.HLi(), 7);
                    break;
                }
                case 183: {
                    this.or_A(this.A, 4);
                    break;
                }
                case 184: {
                    this.cp_A(this.B, 4);
                    break;
                }
                case 185: {
                    this.cp_A(this.C, 4);
                    break;
                }
                case 186: {
                    this.cp_A(this.D, 4);
                    break;
                }
                case 187: {
                    this.cp_A(this.E, 4);
                    break;
                }
                case 188: {
                    this.cp_A(this.H, 4);
                    break;
                }
                case 189: {
                    this.cp_A(this.L, 4);
                    break;
                }
                case 190: {
                    this.cp_A(this.HLi(), 7);
                    break;
                }
                case 191: {
                    this.cp_A(this.A, 4);
                    break;
                }
                case 192: {
                    this.ret_NZ();
                    break;
                }
                case 193: {
                    this.pop_BC();
                    break;
                }
                case 194: {
                    this.jp_NZ_nn();
                    break;
                }
                case 195: {
                    this.jp_nn();
                    break;
                }
                case 196: {
                    this.call_NZ_nn();
                    break;
                }
                case 197: {
                    this.push_BC();
                    break;
                }
                case 198: {
                    this.add_A_n();
                    break;
                }
                case 199: {
                    this.rst(0);
                    break;
                }
                case 200: {
                    this.ret_Z();
                    break;
                }
                case 201: {
                    this.ret();
                    break;
                }
                case 202: {
                    this.jp_Z_nn();
                    break;
                }
                case 203: {
                    this.prefix_BC();
                    break;
                }
                case 204: {
                    this.call_Z_nn();
                    break;
                }
                case 205: {
                    this.call_nn();
                    break;
                }
                case 206: {
                    this.adc_A_n();
                    break;
                }
                case 207: {
                    this.rst(8);
                    break;
                }
                case 208: {
                    this.ret_NC();
                    break;
                }
                case 209: {
                    this.pop_DE();
                    break;
                }
                case 210: {
                    this.jp_NC_nn();
                    break;
                }
                case 211: {
                    this.out_n_A();
                    break;
                }
                case 212: {
                    this.call_NC_nn();
                    break;
                }
                case 213: {
                    this.push_DE();
                    break;
                }
                case 214: {
                    this.sub_A_n();
                    break;
                }
                case 215: {
                    this.rst(16);
                    break;
                }
                case 216: {
                    this.ret_C();
                    break;
                }
                case 217: {
                    this.exx();
                    break;
                }
                case 218: {
                    this.jp_C_nn();
                    break;
                }
                case 219: {
                    this.in_A_n();
                    break;
                }
                case 220: {
                    this.call_C_nn();
                    break;
                }
                case 221: {
                    this.IX = this.execXY(this.IX);
                    break;
                }
                case 222: {
                    this.sbc_A_n();
                    break;
                }
                case 223: {
                    this.rst(24);
                    break;
                }
                case 224: {
                    this.ret_PO();
                    break;
                }
                case 225: {
                    this.pop_HL();
                    break;
                }
                case 226: {
                    this.jp_PO_nn();
                    break;
                }
                case 227: {
                    this.ex_SPi_HL();
                    break;
                }
                case 228: {
                    this.call_PO_nn();
                    break;
                }
                case 229: {
                    this.push_HL();
                    break;
                }
                case 230: {
                    this.and_A_n();
                    break;
                }
                case 231: {
                    this.rst(32);
                    break;
                }
                case 232: {
                    this.ret_PE();
                    break;
                }
                case 233: {
                    this.jp_HLi();
                    break;
                }
                case 234: {
                    this.jp_PE_nn();
                    break;
                }
                case 235: {
                    this.ex_DE_HL();
                    break;
                }
                case 236: {
                    this.call_PE_nn();
                    break;
                }
                case 237: {
                    this.prefix_ED();
                    break;
                }
                case 238: {
                    this.xor_n();
                    break;
                }
                case 239: {
                    this.rst(40);
                    break;
                }
                case 240: {
                    this.ret_P();
                    break;
                }
                case 241: {
                    this.pop_AF();
                    break;
                }
                case 242: {
                    this.jp_P_nn();
                    break;
                }
                case 243: {
                    this.di();
                    break;
                }
                case 244: {
                    this.call_P_nn();
                    break;
                }
                case 245: {
                    this.push_AF();
                    break;
                }
                case 246: {
                    this.or_n();
                    break;
                }
                case 247: {
                    this.rst(48);
                    break;
                }
                case 248: {
                    this.ret_M();
                    break;
                }
                case 249: {
                    this.ld_SP_HL();
                    break;
                }
                case 250: {
                    this.jp_M_nn();
                    break;
                }
                case 251: {
                    this.ei();
                    break;
                }
                case 252: {
                    this.call_M_nn();
                    break;
                }
                case 253: {
                    this.IY = this.execXY(this.IY);
                    break;
                }
                case 254: {
                    this.cp_n();
                    break;
                }
                case 255: {
                    this.rst(56);
                }
            }
        }
    }

    private final void prefix_ED() {
        this.instruction = (this.instruction << 8) + this.ram.read8opc(this.PC);
        this.PC = this.PC + 1 & 0xFFFF;
        switch (this.instruction & 0xFF) {
            case 64: {
                this.cycle -= 12;
                this.B = this.in(this.C, this.B);
                break;
            }
            case 65: {
                this.cycle -= 12;
                this.out(this.C, this.B);
                break;
            }
            case 66: {
                this.cycle -= 15;
                this.sbcHL(this.BC());
                break;
            }
            case 67: {
                this.cycle -= 20;
                this.ram.write16(this.ram.read16arg(this.PC), this.BC());
                this.PC += 2;
                break;
            }
            case 68: {
                this.cycle -= 13;
                int tmp1 = this.A;
                this.A = 0;
                this.A = this.subA_8(tmp1, this.A);
                break;
            }
            case 69: {
                this.cycle -= 14;
                this.PC = this.ram.read16arg(this.SP);
                this.SP += 2;
                this.IFF0 = this.IFF1;
                this.cycle = this.checkInterrupt(this.cycle);
                break;
            }
            case 70: {
                this.cycle -= 8;
                this.IM = 0;
                break;
            }
            case 71: {
                this.cycle -= 9;
                this.I = this.A;
                break;
            }
            case 72: {
                this.cycle -= 12;
                this.C = this.in(this.C, this.C);
                break;
            }
            case 73: {
                this.cycle -= 12;
                this.out(this.C, this.D);
                break;
            }
            case 74: {
                this.cycle -= 15;
                this.adcHL(this.BC());
                break;
            }
            case 75: {
                this.cycle -= 20;
                this.B = this.ram.read8(this.ram.read16arg(this.PC) + 1);
                this.C = this.ram.read8(this.ram.read16arg(this.PC));
                this.PC += 2;
                break;
            }
            case 76: {
                this.cycle -= 13;
                int tmp1 = this.A;
                this.A = 0;
                this.A = this.subA_8(tmp1, this.A);
                break;
            }
            case 77: {
                this.cycle -= 14;
                this.PC = this.ram.read16arg(this.SP);
                this.SP += 2;
                break;
            }
            case 78: {
                this.cycle -= 8;
                this.IM = 0;
                break;
            }
            case 79: {
                this.cycle -= 9;
                this.R = this.A;
                this.R2 = this.A & 0x80;
                break;
            }
            case 80: {
                this.cycle -= 12;
                this.D = this.in(this.C, this.D);
                break;
            }
            case 81: {
                this.cycle -= 12;
                this.out(this.C, this.D);
                break;
            }
            case 82: {
                this.cycle -= 15;
                this.sbcHL(this.DE());
                break;
            }
            case 83: {
                this.cycle -= 20;
                this.ram.write16(this.ram.read16arg(this.PC), this.DE());
                this.PC += 2;
                break;
            }
            case 84: {
                this.cycle -= 13;
                int tmp1 = this.A;
                this.A = 0;
                this.A = this.subA_8(tmp1, this.A);
                break;
            }
            case 85: {
                this.cycle -= 14;
                this.PC = this.ram.read16arg(this.SP);
                this.SP += 2;
                this.IFF0 = this.IFF1;
                this.cycle = this.checkInterrupt(this.cycle);
                break;
            }
            case 86: {
                this.cycle -= 8;
                this.IM = 1;
                break;
            }
            case 87: {
                this.cycle -= 9;
                this.A = this.I;
                break;
            }
            case 88: {
                this.cycle -= 12;
                this.E = this.in(this.C, this.E);
                break;
            }
            case 89: {
                this.cycle -= 12;
                this.out(this.C, this.E);
                break;
            }
            case 90: {
                this.cycle -= 15;
                this.adcHL(this.DE());
                break;
            }
            case 91: {
                this.cycle -= 20;
                this.D = this.ram.read8(this.ram.read16arg(this.PC) + 1);
                this.E = this.ram.read8(this.ram.read16arg(this.PC));
                this.PC += 2;
                break;
            }
            case 92: {
                this.cycle -= 13;
                int tmp1 = this.A;
                this.A = 0;
                this.A = this.subA_8(tmp1, this.A);
                break;
            }
            case 93: {
                this.cycle -= 14;
                this.PC = this.ram.read16arg(this.SP);
                this.SP += 2;
                break;
            }
            case 94: {
                this.cycle -= 8;
                this.IM = 2;
                break;
            }
            case 95: {
                this.cycle -= 9;
                this.A = this.R() & 0x7F | this.R2;
                this.F = this.F & 1 | SZ[this.A] | (this.IFF1 ? 2 : 0);
                break;
            }
            case 96: {
                this.cycle -= 12;
                this.H = this.in(this.C, this.H);
                break;
            }
            case 97: {
                this.cycle -= 12;
                this.out(this.C, this.H);
                break;
            }
            case 98: {
                this.cycle -= 15;
                this.sbcHL(this.HL());
                break;
            }
            case 99: {
                this.cycle -= 20;
                this.ram.write16(this.ram.read16arg(this.PC), this.HL());
                this.PC += 2;
                break;
            }
            case 100: {
                this.cycle -= 13;
                int tmp1 = this.A;
                this.A = 0;
                this.A = this.subA_8(tmp1, this.A);
                break;
            }
            case 101: {
                this.cycle -= 14;
                this.PC = this.ram.read16arg(this.SP);
                this.SP += 2;
                this.IFF0 = this.IFF1;
                this.cycle = this.checkInterrupt(this.cycle);
                break;
            }
            case 102: {
                this.cycle -= 8;
                this.IM = 0;
                break;
            }
            case 103: {
                this.cycle -= 18;
                this.A = this.rrd_A(this.A, this.H, this.L);
                break;
            }
            case 104: {
                this.cycle -= 12;
                this.L = this.in(this.C, this.L);
                break;
            }
            case 105: {
                this.cycle -= 12;
                this.out(this.C, this.L);
                break;
            }
            case 106: {
                this.cycle -= 15;
                this.adcHL(this.HL());
                break;
            }
            case 107: {
                this.cycle -= 20;
                this.H = this.ram.read8(this.ram.read16arg(this.PC) + 1);
                this.L = this.ram.read8(this.ram.read16arg(this.PC));
                this.PC += 2;
                break;
            }
            case 108: {
                this.cycle -= 13;
                int tmp1 = this.A;
                this.A = 0;
                this.A = this.subA_8(tmp1, this.A);
                break;
            }
            case 109: {
                this.cycle -= 14;
                this.PC = this.ram.read16arg(this.SP);
                this.SP += 2;
                break;
            }
            case 110: {
                this.cycle -= 8;
                this.IM = 0;
                break;
            }
            case 111: {
                this.cycle -= 18;
                this.A = this.rld_A(this.A, this.H, this.L);
                break;
            }
            case 114: {
                this.cycle -= 15;
                this.sbcHL(this.SP);
                break;
            }
            case 115: {
                this.cycle -= 20;
                this.ram.write16(this.ram.read16arg(this.PC), this.SP);
                this.PC += 2;
                break;
            }
            case 120: {
                this.cycle -= 12;
                this.A = this.in(this.C, this.A);
                break;
            }
            case 121: {
                this.cycle -= 11;
                this.out(this.C, this.A);
                break;
            }
            case 122: {
                this.cycle -= 15;
                this.adcHL(this.SP);
                break;
            }
            case 123: {
                this.cycle -= 20;
                this.SP = this.ram.read16(this.ram.read16arg(this.PC));
                this.PC += 2;
                break;
            }
            case 160: {
                this.cycle -= 21;
                int tmp1 = this.DE();
                int tmp2 = this.HL();
                int tmp3 = this.BC();
                this.ram.write8(tmp1, this.ram.read8(tmp2++));
                tmp1 = tmp1 + 1 & 0xFFFF;
                tmp3 = tmp3 - 1 & 0xFFFF;
                this.E = tmp1 & 0xFF;
                this.D = tmp1 >> 8;
                this.L = tmp2 & 0xFF;
                this.H = tmp2 >> 8;
                this.C = tmp3 & 0xFF;
                this.B = tmp3 >> 8;
                this.F &= 0xC1;
                if (tmp3 == 0) break;
                this.F |= 4;
                break;
            }
            case 161: {
                this.cycle -= 21;
                int tmp1 = this.HL();
                int tmp2 = this.BC();
                int value = this.ram.read8arg(tmp1);
                int result = this.A - value & 0xFF;
                ++tmp1;
                --tmp2;
                this.F = this.F & 1 | SZ[result] & 0xFFFFFFD7 | (this.A ^ value ^ result) & 0x10 | 2;
                if ((this.F & 0x10) != 0) {
                    result = result - 1 & 0xFF;
                }
                if ((result & 2) != 0) {
                    this.F |= 0x20;
                }
                if ((result & 8) != 0) {
                    this.F |= 8;
                }
                if (tmp2 != 0) {
                    this.F |= 4;
                }
                this.H = tmp1 >> 8;
                this.L = tmp1 & 0xFF;
                this.B = tmp2 >> 8;
                this.C = tmp2 & 0xFF;
                break;
            }
            case 162: {
                this.cycle -= 16;
                int tmp1 = this.HL();
                this.B = this.B - 1 & 0xFF;
                this.ram.write8(tmp1++, this.in(this.B, this.A));
                this.H = (tmp1 &= 0xFFFF) >> 8;
                this.L = tmp1 & 0xFF;
                this.F = this.B == 0 ? (this.F |= 0x40) : (this.F &= 0xFFFFFFBF);
                this.F |= 2;
                break;
            }
            case 163: {
                this.cycle -= 16;
                int tmp1 = this.HL();
                this.out(this.B, this.ram.read8(tmp1++));
                this.B = this.B - 1 & 0xFF;
                this.H = tmp1 >> 8;
                this.L = tmp1 & 0xFF;
                this.F = this.B == 0 ? (this.F |= 0x40) : (this.F &= 0xFFFFFFBF);
                this.F |= 2;
                break;
            }
            case 168: {
                this.cycle -= 21;
                int tmp1 = this.DE();
                int tmp2 = this.HL();
                int tmp3 = this.BC();
                this.ram.write8(tmp1, this.ram.read8(tmp2--));
                tmp1 = tmp1 - 1 & 0xFFFF;
                tmp3 = tmp3 - 1 & 0xFFFF;
                this.E = tmp1 & 0xFF;
                this.D = tmp1 >> 8;
                this.L = tmp2 & 0xFF;
                this.H = tmp2 >> 8;
                this.C = tmp3 & 0xFF;
                this.B = tmp3 >> 8;
                this.F &= 0xC1;
                if (tmp3 == 0) break;
                this.F |= 4;
                break;
            }
            case 170: {
                this.cycle -= 16;
                int tmp1 = this.HL();
                this.B = this.B - 1 & 0xFF;
                this.ram.write8(tmp1--, this.in(this.B, this.A));
                this.H = (tmp1 &= 0xFFFF) >> 8;
                this.L = tmp1 & 0xFF;
                this.F = this.B == 0 ? (this.F |= 0x40) : (this.F &= 0xFFFFFFBF);
                this.F |= 2;
                break;
            }
            case 176: {
                this.cycle -= 5 + 16 * this.BC();
                int tmp1 = this.DE();
                int tmp2 = this.HL();
                int n = this.BC();
                while (n > 0) {
                    this.ram.write8(tmp1, this.ram.read8(tmp2));
                    tmp1 = tmp1 + 1 & 0xFFFF;
                    tmp2 = tmp2 + 1 & 0xFFFF;
                    --n;
                }
                this.E = tmp1 & 0xFF;
                this.D = tmp1 >> 8;
                this.C = 0;
                this.B = 0;
                this.L = tmp2 & 0xFF;
                this.H = tmp2 >> 8;
                this.F &= 0xE9;
                break;
            }
            case 177: {
                int tmp2 = this.F & 1;
                int tmp1 = this.BC();
                int tmp3 = this.HL();
                this.cycle -= 4;
                this.cpA_8(this.ram.read8(tmp3), this.A);
                this.H = ++tmp3 >> 8;
                this.L = tmp3 & 0xFF;
                this.B = --tmp1 >> 8;
                this.C = tmp1 & 0xFF;
                this.F = this.F & 0xFE | tmp2;
                if (tmp1 != 0 && (this.F & 0x40) == 0) {
                    this.PC -= 2;
                    this.F |= 4;
                    this.cycle -= 21;
                    break;
                }
                this.F &= 0xFB;
                this.cycle -= 16;
                break;
            }
            case 179: {
                this.cycle -= 5 + 16 * this.B;
                while (this.B > 0) {
                    int tmp1 = this.HL();
                    this.out(this.B, this.ram.read8(tmp1++));
                    this.B = this.B - 1 & 0xFF;
                    this.H = tmp1 >> 8;
                    this.L = tmp1 & 0xFF;
                    if (this.B == 0) {
                        this.F |= 0x40;
                        continue;
                    }
                    this.F &= 0xFFFFFFBF;
                }
                this.F |= 2;
                break;
            }
            case 184: {
                this.cycle -= 5 + 16 * this.BC();
                int tmp1 = this.DE();
                int tmp2 = this.HL();
                int n = this.BC();
                while (n > 0) {
                    this.ram.write8(tmp1--, this.ram.read8(tmp2--));
                    --n;
                }
                this.E = tmp1 & 0xFF;
                this.D = tmp1 >> 8;
                this.C = 0;
                this.B = 0;
                this.L = tmp2 & 0xFF;
                this.H = tmp2 >> 8;
                this.F &= 0xE9;
                break;
            }
            case 185: {
                int tmp2 = this.F & 1;
                int tmp1 = this.BC();
                int tmp3 = this.HL();
                this.cycle -= 4;
                this.cpA_8(this.ram.read8(tmp3), this.A);
                this.H = --tmp3 >> 8;
                this.L = tmp3 & 0xFF;
                this.B = --tmp1 >> 8;
                this.C = tmp1 & 0xFF;
                this.F = this.F & 0xFE | tmp2;
                if (tmp1 != 0 && (this.F & 0x40) == 0) {
                    this.PC -= 2;
                    this.F |= 4;
                    this.cycle -= 21;
                    break;
                }
                this.F &= 0xFB;
                this.cycle -= 16;
                break;
            }
            default: {
                this.error(this.instruction, this.PPC);
            }
        }
    }

    private final void prefix_BC() {
        this.instruction = (this.instruction << 8) + this.ram.read8opc(this.PC++);
        switch (this.instruction & 0xFF) {
            case 0: {
                this.cycle -= 8;
                this.B = this.rlc(this.B);
                break;
            }
            case 1: {
                this.cycle -= 8;
                this.C = this.rlc(this.C);
                break;
            }
            case 2: {
                this.cycle -= 8;
                this.D = this.rlc(this.D);
                break;
            }
            case 3: {
                this.cycle -= 8;
                this.E = this.rlc(this.E);
                break;
            }
            case 4: {
                this.cycle -= 8;
                this.H = this.rlc(this.H);
                break;
            }
            case 5: {
                this.cycle -= 8;
                this.L = this.rlc(this.L);
                break;
            }
            case 6: {
                this.cycle -= 15;
                this.ram.write8(this.HL(), this.rlc(this.HLi()));
                break;
            }
            case 7: {
                this.cycle -= 8;
                this.A = this.rlc(this.A);
                break;
            }
            case 8: {
                this.cycle -= 8;
                this.B = this.rrc(this.B);
                break;
            }
            case 9: {
                this.cycle -= 8;
                this.C = this.rrc(this.C);
                break;
            }
            case 10: {
                this.cycle -= 8;
                this.D = this.rrc(this.D);
                break;
            }
            case 11: {
                this.cycle -= 8;
                this.E = this.rrc(this.E);
                break;
            }
            case 12: {
                this.cycle -= 8;
                this.H = this.rrc(this.H);
                break;
            }
            case 13: {
                this.cycle -= 8;
                this.L = this.rrc(this.L);
                break;
            }
            case 14: {
                this.cycle -= 15;
                this.ram.write8(this.HL(), this.rrc(this.HLi()));
                break;
            }
            case 15: {
                this.cycle -= 8;
                this.A = this.rrc(this.A);
                break;
            }
            case 16: {
                this.cycle -= 8;
                this.B = this.rl(this.B);
                break;
            }
            case 17: {
                this.cycle -= 8;
                this.C = this.rl(this.C);
                break;
            }
            case 18: {
                this.cycle -= 8;
                this.D = this.rl(this.D);
                break;
            }
            case 19: {
                this.cycle -= 8;
                this.E = this.rl(this.E);
                break;
            }
            case 20: {
                this.cycle -= 8;
                this.H = this.rl(this.H);
                break;
            }
            case 21: {
                this.cycle -= 8;
                this.L = this.rl(this.L);
                break;
            }
            case 22: {
                this.cycle -= 15;
                this.ram.write8(this.HL(), this.rl(this.HLi()));
                break;
            }
            case 23: {
                this.cycle -= 8;
                this.A = this.rl(this.A);
                break;
            }
            case 24: {
                this.cycle -= 8;
                this.B = this.rr(this.B);
                break;
            }
            case 25: {
                this.cycle -= 8;
                this.C = this.rr(this.C);
                break;
            }
            case 26: {
                this.cycle -= 8;
                this.D = this.rr(this.D);
                break;
            }
            case 27: {
                this.cycle -= 8;
                this.E = this.rr(this.E);
                break;
            }
            case 28: {
                this.cycle -= 8;
                this.H = this.rr(this.H);
                break;
            }
            case 29: {
                this.cycle -= 8;
                this.L = this.rr(this.L);
                break;
            }
            case 30: {
                this.cycle -= 15;
                this.ram.write8(this.HL(), this.rr(this.HLi()));
                break;
            }
            case 31: {
                this.cycle -= 8;
                this.A = this.rr(this.A);
                break;
            }
            case 32: {
                this.cycle -= 8;
                this.B = this.sla(this.B);
                break;
            }
            case 33: {
                this.cycle -= 8;
                this.C = this.sla(this.C);
                break;
            }
            case 34: {
                this.cycle -= 8;
                this.D = this.sla(this.D);
                break;
            }
            case 35: {
                this.cycle -= 8;
                this.E = this.sla(this.E);
                break;
            }
            case 36: {
                this.cycle -= 8;
                this.H = this.sla(this.H);
                break;
            }
            case 37: {
                this.cycle -= 8;
                this.L = this.sla(this.L);
                break;
            }
            case 38: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.sla(this.HLi()));
                break;
            }
            case 39: {
                this.cycle -= 8;
                this.A = this.sla(this.A);
                break;
            }
            case 40: {
                this.cycle -= 8;
                this.B = this.sra(this.B);
                break;
            }
            case 41: {
                this.cycle -= 8;
                this.C = this.sra(this.C);
                break;
            }
            case 42: {
                this.cycle -= 8;
                this.D = this.sra(this.D);
                break;
            }
            case 43: {
                this.cycle -= 8;
                this.E = this.sra(this.E);
                break;
            }
            case 44: {
                this.cycle -= 8;
                this.H = this.sra(this.H);
                break;
            }
            case 45: {
                this.cycle -= 8;
                this.L = this.sra(this.L);
                break;
            }
            case 46: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.sra(this.HLi()));
                break;
            }
            case 47: {
                this.cycle -= 8;
                this.A = this.sra(this.A);
                break;
            }
            case 48: {
                this.cycle -= 8;
                this.B = this.sll(this.B);
                break;
            }
            case 49: {
                this.cycle -= 8;
                this.C = this.sll(this.C);
                break;
            }
            case 50: {
                this.cycle -= 8;
                this.D = this.sll(this.D);
                break;
            }
            case 51: {
                this.cycle -= 8;
                this.E = this.sll(this.E);
                break;
            }
            case 52: {
                this.cycle -= 8;
                this.H = this.sll(this.H);
                break;
            }
            case 53: {
                this.cycle -= 8;
                this.L = this.sll(this.L);
                break;
            }
            case 54: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.sll(this.HLi()));
                break;
            }
            case 55: {
                this.cycle -= 8;
                this.A = this.sll(this.A);
                break;
            }
            case 56: {
                this.cycle -= 8;
                this.B = this.srl(this.B);
                break;
            }
            case 57: {
                this.cycle -= 8;
                this.C = this.srl(this.C);
                break;
            }
            case 58: {
                this.cycle -= 8;
                this.D = this.srl(this.D);
                break;
            }
            case 59: {
                this.cycle -= 8;
                this.E = this.srl(this.E);
                break;
            }
            case 60: {
                this.cycle -= 8;
                this.H = this.srl(this.H);
                break;
            }
            case 61: {
                this.cycle -= 8;
                this.L = this.srl(this.L);
                break;
            }
            case 62: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.srl(this.HLi()));
                break;
            }
            case 63: {
                this.cycle -= 8;
                this.A = this.srl(this.A);
                break;
            }
            case 64: {
                this.cycle -= 8;
                this.bit(0, this.B);
                break;
            }
            case 65: {
                this.cycle -= 8;
                this.bit(0, this.C);
                break;
            }
            case 66: {
                this.cycle -= 8;
                this.bit(0, this.D);
                break;
            }
            case 67: {
                this.cycle -= 8;
                this.bit(0, this.E);
                break;
            }
            case 68: {
                this.cycle -= 8;
                this.bit(0, this.H);
                break;
            }
            case 69: {
                this.cycle -= 8;
                this.bit(0, this.L);
                break;
            }
            case 70: {
                this.cycle -= 12;
                this.bit(0, this.HLi());
                break;
            }
            case 71: {
                this.cycle -= 8;
                this.bit(0, this.A);
                break;
            }
            case 72: {
                this.cycle -= 8;
                this.bit(1, this.B);
                break;
            }
            case 73: {
                this.cycle -= 8;
                this.bit(1, this.C);
                break;
            }
            case 74: {
                this.cycle -= 8;
                this.bit(1, this.D);
                break;
            }
            case 75: {
                this.cycle -= 8;
                this.bit(1, this.E);
                break;
            }
            case 76: {
                this.cycle -= 8;
                this.bit(1, this.H);
                break;
            }
            case 77: {
                this.cycle -= 8;
                this.bit(1, this.L);
                break;
            }
            case 78: {
                this.cycle -= 12;
                this.bit(1, this.HLi());
                break;
            }
            case 79: {
                this.cycle -= 8;
                this.bit(1, this.A);
                break;
            }
            case 80: {
                this.cycle -= 8;
                this.bit(2, this.B);
                break;
            }
            case 81: {
                this.cycle -= 8;
                this.bit(2, this.C);
                break;
            }
            case 82: {
                this.cycle -= 8;
                this.bit(2, this.D);
                break;
            }
            case 83: {
                this.cycle -= 8;
                this.bit(2, this.E);
                break;
            }
            case 84: {
                this.cycle -= 8;
                this.bit(2, this.H);
                break;
            }
            case 85: {
                this.cycle -= 8;
                this.bit(2, this.L);
                break;
            }
            case 86: {
                this.cycle -= 12;
                this.bit(2, this.HLi());
                break;
            }
            case 87: {
                this.cycle -= 8;
                this.bit(2, this.A);
                break;
            }
            case 88: {
                this.cycle -= 8;
                this.bit(3, this.B);
                break;
            }
            case 89: {
                this.cycle -= 8;
                this.bit(3, this.C);
                break;
            }
            case 90: {
                this.cycle -= 8;
                this.bit(3, this.D);
                break;
            }
            case 91: {
                this.cycle -= 8;
                this.bit(3, this.E);
                break;
            }
            case 92: {
                this.cycle -= 8;
                this.bit(3, this.H);
                break;
            }
            case 93: {
                this.cycle -= 8;
                this.bit(3, this.L);
                break;
            }
            case 94: {
                this.cycle -= 12;
                this.bit(3, this.HLi());
                break;
            }
            case 95: {
                this.cycle -= 8;
                this.bit(3, this.A);
                break;
            }
            case 96: {
                this.cycle -= 8;
                this.bit(4, this.B);
                break;
            }
            case 97: {
                this.cycle -= 8;
                this.bit(4, this.C);
                break;
            }
            case 98: {
                this.cycle -= 8;
                this.bit(4, this.D);
                break;
            }
            case 99: {
                this.cycle -= 8;
                this.bit(4, this.E);
                break;
            }
            case 100: {
                this.cycle -= 8;
                this.bit(4, this.H);
                break;
            }
            case 101: {
                this.cycle -= 8;
                this.bit(4, this.L);
                break;
            }
            case 102: {
                this.cycle -= 12;
                this.bit(4, this.HLi());
                break;
            }
            case 103: {
                this.cycle -= 8;
                this.bit(4, this.A);
                break;
            }
            case 104: {
                this.cycle -= 8;
                this.bit(5, this.B);
                break;
            }
            case 105: {
                this.cycle -= 8;
                this.bit(5, this.C);
                break;
            }
            case 106: {
                this.cycle -= 8;
                this.bit(5, this.D);
                break;
            }
            case 107: {
                this.cycle -= 8;
                this.bit(5, this.E);
                break;
            }
            case 108: {
                this.cycle -= 8;
                this.bit(5, this.H);
                break;
            }
            case 109: {
                this.cycle -= 8;
                this.bit(5, this.L);
                break;
            }
            case 110: {
                this.cycle -= 12;
                this.bit(5, this.HLi());
                break;
            }
            case 111: {
                this.cycle -= 8;
                this.bit(5, this.A);
                break;
            }
            case 112: {
                this.cycle -= 8;
                this.bit(6, this.B);
                break;
            }
            case 113: {
                this.cycle -= 8;
                this.bit(6, this.C);
                break;
            }
            case 114: {
                this.cycle -= 8;
                this.bit(6, this.D);
                break;
            }
            case 115: {
                this.cycle -= 8;
                this.bit(6, this.E);
                break;
            }
            case 116: {
                this.cycle -= 8;
                this.bit(6, this.H);
                break;
            }
            case 117: {
                this.cycle -= 8;
                this.bit(6, this.L);
                break;
            }
            case 118: {
                this.cycle -= 12;
                this.bit(6, this.HLi());
                break;
            }
            case 119: {
                this.cycle -= 8;
                this.bit(6, this.A);
                break;
            }
            case 120: {
                this.cycle -= 8;
                this.bit(7, this.B);
                break;
            }
            case 121: {
                this.cycle -= 8;
                this.bit(7, this.C);
                break;
            }
            case 122: {
                this.cycle -= 8;
                this.bit(7, this.D);
                break;
            }
            case 123: {
                this.cycle -= 8;
                this.bit(7, this.E);
                break;
            }
            case 124: {
                this.cycle -= 8;
                this.bit(7, this.H);
                break;
            }
            case 125: {
                this.cycle -= 8;
                this.bit(7, this.L);
                break;
            }
            case 126: {
                this.cycle -= 12;
                this.bit(7, this.HLi());
                break;
            }
            case 127: {
                this.cycle -= 8;
                this.bit(7, this.A);
                break;
            }
            case 128: {
                this.cycle -= 8;
                this.B = this.res(0, this.B);
                break;
            }
            case 129: {
                this.cycle -= 8;
                this.C = this.res(0, this.C);
                break;
            }
            case 130: {
                this.cycle -= 8;
                this.D = this.res(0, this.D);
                break;
            }
            case 131: {
                this.cycle -= 8;
                this.E = this.res(0, this.E);
                break;
            }
            case 132: {
                this.cycle -= 8;
                this.H = this.res(0, this.H);
                break;
            }
            case 133: {
                this.cycle -= 8;
                this.L = this.res(0, this.L);
                break;
            }
            case 134: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(0, this.HLi()));
                break;
            }
            case 135: {
                this.cycle -= 8;
                this.A = this.res(0, this.A);
                break;
            }
            case 136: {
                this.cycle -= 8;
                this.B = this.res(1, this.B);
                break;
            }
            case 137: {
                this.cycle -= 8;
                this.C = this.res(1, this.C);
                break;
            }
            case 138: {
                this.cycle -= 8;
                this.D = this.res(1, this.D);
                break;
            }
            case 139: {
                this.cycle -= 8;
                this.E = this.res(1, this.E);
                break;
            }
            case 140: {
                this.cycle -= 8;
                this.H = this.res(1, this.H);
                break;
            }
            case 141: {
                this.cycle -= 8;
                this.L = this.res(1, this.L);
                break;
            }
            case 142: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(1, this.HLi()));
                break;
            }
            case 143: {
                this.cycle -= 8;
                this.A = this.res(1, this.A);
                break;
            }
            case 144: {
                this.cycle -= 8;
                this.B = this.res(2, this.B);
                break;
            }
            case 145: {
                this.cycle -= 8;
                this.C = this.res(2, this.C);
                break;
            }
            case 146: {
                this.cycle -= 8;
                this.D = this.res(2, this.D);
                break;
            }
            case 147: {
                this.cycle -= 8;
                this.E = this.res(2, this.E);
                break;
            }
            case 148: {
                this.cycle -= 8;
                this.H = this.res(2, this.H);
                break;
            }
            case 149: {
                this.cycle -= 8;
                this.L = this.res(2, this.L);
                break;
            }
            case 150: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(2, this.HLi()));
                break;
            }
            case 151: {
                this.cycle -= 8;
                this.A = this.res(2, this.A);
                break;
            }
            case 152: {
                this.cycle -= 8;
                this.B = this.res(3, this.B);
                break;
            }
            case 153: {
                this.cycle -= 8;
                this.C = this.res(3, this.C);
                break;
            }
            case 154: {
                this.cycle -= 8;
                this.D = this.res(3, this.D);
                break;
            }
            case 155: {
                this.cycle -= 8;
                this.E = this.res(3, this.E);
                break;
            }
            case 156: {
                this.cycle -= 8;
                this.H = this.res(3, this.H);
                break;
            }
            case 157: {
                this.cycle -= 8;
                this.L = this.res(3, this.L);
                break;
            }
            case 158: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(3, this.HLi()));
                break;
            }
            case 159: {
                this.cycle -= 8;
                this.A = this.res(3, this.A);
                break;
            }
            case 160: {
                this.cycle -= 8;
                this.B = this.res(4, this.B);
                break;
            }
            case 161: {
                this.cycle -= 8;
                this.C = this.res(4, this.C);
                break;
            }
            case 162: {
                this.cycle -= 8;
                this.D = this.res(4, this.D);
                break;
            }
            case 163: {
                this.cycle -= 8;
                this.E = this.res(4, this.E);
                break;
            }
            case 164: {
                this.cycle -= 8;
                this.H = this.res(4, this.H);
                break;
            }
            case 165: {
                this.cycle -= 8;
                this.L = this.res(4, this.L);
                break;
            }
            case 166: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(4, this.HLi()));
                break;
            }
            case 167: {
                this.cycle -= 8;
                this.A = this.res(4, this.A);
                break;
            }
            case 168: {
                this.cycle -= 8;
                this.B = this.res(5, this.B);
                break;
            }
            case 169: {
                this.cycle -= 8;
                this.C = this.res(5, this.C);
                break;
            }
            case 170: {
                this.cycle -= 8;
                this.D = this.res(5, this.D);
                break;
            }
            case 171: {
                this.cycle -= 8;
                this.E = this.res(5, this.E);
                break;
            }
            case 172: {
                this.cycle -= 8;
                this.H = this.res(5, this.H);
                break;
            }
            case 173: {
                this.cycle -= 8;
                this.L = this.res(5, this.L);
                break;
            }
            case 174: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(5, this.HLi()));
                break;
            }
            case 175: {
                this.cycle -= 8;
                this.A = this.res(5, this.A);
                break;
            }
            case 176: {
                this.cycle -= 8;
                this.B = this.res(6, this.B);
                break;
            }
            case 177: {
                this.cycle -= 8;
                this.C = this.res(6, this.C);
                break;
            }
            case 178: {
                this.cycle -= 8;
                this.D = this.res(6, this.D);
                break;
            }
            case 179: {
                this.cycle -= 8;
                this.E = this.res(6, this.E);
                break;
            }
            case 180: {
                this.cycle -= 8;
                this.H = this.res(6, this.H);
                break;
            }
            case 181: {
                this.cycle -= 8;
                this.L = this.res(6, this.L);
                break;
            }
            case 182: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(6, this.HLi()));
                break;
            }
            case 183: {
                this.cycle -= 8;
                this.A = this.res(6, this.A);
                break;
            }
            case 184: {
                this.cycle -= 8;
                this.B = this.res(7, this.B);
                break;
            }
            case 185: {
                this.cycle -= 8;
                this.C = this.res(7, this.C);
                break;
            }
            case 186: {
                this.cycle -= 8;
                this.D = this.res(7, this.D);
                break;
            }
            case 187: {
                this.cycle -= 8;
                this.E = this.res(7, this.E);
                break;
            }
            case 188: {
                this.cycle -= 8;
                this.H = this.res(7, this.H);
                break;
            }
            case 189: {
                this.cycle -= 8;
                this.L = this.res(7, this.L);
                break;
            }
            case 190: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.res(7, this.HLi()));
                break;
            }
            case 191: {
                this.cycle -= 8;
                this.A = this.res(7, this.A);
                break;
            }
            case 192: {
                this.cycle -= 8;
                this.B = this.set(0, this.B);
                break;
            }
            case 193: {
                this.cycle -= 8;
                this.C = this.set(0, this.C);
                break;
            }
            case 194: {
                this.cycle -= 8;
                this.D = this.set(0, this.D);
                break;
            }
            case 195: {
                this.cycle -= 8;
                this.E = this.set(0, this.E);
                break;
            }
            case 196: {
                this.cycle -= 8;
                this.H = this.set(0, this.H);
                break;
            }
            case 197: {
                this.cycle -= 8;
                this.L = this.set(0, this.L);
                break;
            }
            case 198: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(0, this.HLi()));
                break;
            }
            case 199: {
                this.cycle -= 8;
                this.A = this.set(0, this.A);
                break;
            }
            case 200: {
                this.cycle -= 8;
                this.B = this.set(1, this.B);
                break;
            }
            case 201: {
                this.cycle -= 8;
                this.C = this.set(1, this.C);
                break;
            }
            case 202: {
                this.cycle -= 8;
                this.D = this.set(1, this.D);
                break;
            }
            case 203: {
                this.cycle -= 8;
                this.E = this.set(1, this.E);
                break;
            }
            case 204: {
                this.cycle -= 8;
                this.H = this.set(1, this.H);
                break;
            }
            case 205: {
                this.cycle -= 8;
                this.L = this.set(1, this.L);
                break;
            }
            case 206: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(1, this.HLi()));
                break;
            }
            case 207: {
                this.cycle -= 8;
                this.A = this.set(1, this.A);
                break;
            }
            case 208: {
                this.cycle -= 8;
                this.B = this.set(2, this.B);
                break;
            }
            case 209: {
                this.cycle -= 8;
                this.C = this.set(2, this.C);
                break;
            }
            case 210: {
                this.cycle -= 8;
                this.D = this.set(2, this.D);
                break;
            }
            case 211: {
                this.cycle -= 8;
                this.E = this.set(2, this.E);
                break;
            }
            case 212: {
                this.cycle -= 8;
                this.H = this.set(2, this.H);
                break;
            }
            case 213: {
                this.cycle -= 8;
                this.L = this.set(2, this.L);
                break;
            }
            case 214: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(2, this.HLi()));
                break;
            }
            case 215: {
                this.cycle -= 8;
                this.A = this.set(2, this.A);
                break;
            }
            case 216: {
                this.cycle -= 8;
                this.B = this.set(3, this.B);
                break;
            }
            case 217: {
                this.cycle -= 8;
                this.C = this.set(3, this.C);
                break;
            }
            case 218: {
                this.cycle -= 8;
                this.D = this.set(3, this.D);
                break;
            }
            case 219: {
                this.cycle -= 8;
                this.E = this.set(3, this.E);
                break;
            }
            case 220: {
                this.cycle -= 8;
                this.H = this.set(3, this.H);
                break;
            }
            case 221: {
                this.cycle -= 8;
                this.L = this.set(3, this.L);
                break;
            }
            case 222: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(3, this.HLi()));
                break;
            }
            case 223: {
                this.cycle -= 8;
                this.A = this.set(3, this.A);
                break;
            }
            case 224: {
                this.cycle -= 8;
                this.B = this.set(4, this.B);
                break;
            }
            case 225: {
                this.cycle -= 8;
                this.C = this.set(4, this.C);
                break;
            }
            case 226: {
                this.cycle -= 8;
                this.D = this.set(4, this.D);
                break;
            }
            case 227: {
                this.cycle -= 8;
                this.E = this.set(4, this.E);
                break;
            }
            case 228: {
                this.cycle -= 8;
                this.H = this.set(4, this.H);
                break;
            }
            case 229: {
                this.cycle -= 8;
                this.L = this.set(4, this.L);
                break;
            }
            case 230: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(4, this.HLi()));
                break;
            }
            case 231: {
                this.cycle -= 8;
                this.A = this.set(4, this.A);
                break;
            }
            case 232: {
                this.cycle -= 8;
                this.B = this.set(5, this.B);
                break;
            }
            case 233: {
                this.cycle -= 8;
                this.C = this.set(5, this.C);
                break;
            }
            case 234: {
                this.cycle -= 8;
                this.D = this.set(5, this.D);
                break;
            }
            case 235: {
                this.cycle -= 8;
                this.E = this.set(5, this.E);
                break;
            }
            case 236: {
                this.cycle -= 8;
                this.H = this.set(5, this.H);
                break;
            }
            case 237: {
                this.cycle -= 8;
                this.L = this.set(5, this.L);
                break;
            }
            case 238: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(5, this.HLi()));
                break;
            }
            case 239: {
                this.cycle -= 8;
                this.A = this.set(5, this.A);
                break;
            }
            case 240: {
                this.cycle -= 8;
                this.B = this.set(6, this.B);
                break;
            }
            case 241: {
                this.cycle -= 8;
                this.C = this.set(6, this.C);
                break;
            }
            case 242: {
                this.cycle -= 8;
                this.D = this.set(6, this.D);
                break;
            }
            case 243: {
                this.cycle -= 8;
                this.E = this.set(6, this.E);
                break;
            }
            case 244: {
                this.cycle -= 8;
                this.H = this.set(6, this.H);
                break;
            }
            case 245: {
                this.cycle -= 8;
                this.L = this.set(6, this.L);
                break;
            }
            case 246: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(6, this.HLi()));
                break;
            }
            case 247: {
                this.cycle -= 8;
                this.A = this.set(6, this.A);
                break;
            }
            case 248: {
                this.cycle -= 8;
                this.B = this.set(7, this.B);
                break;
            }
            case 249: {
                this.cycle -= 8;
                this.C = this.set(7, this.C);
                break;
            }
            case 250: {
                this.cycle -= 8;
                this.D = this.set(7, this.D);
                break;
            }
            case 251: {
                this.cycle -= 8;
                this.E = this.set(7, this.E);
                break;
            }
            case 252: {
                this.cycle -= 8;
                this.H = this.set(7, this.H);
                break;
            }
            case 253: {
                this.cycle -= 8;
                this.L = this.set(7, this.L);
                break;
            }
            case 254: {
                this.cycle -= 12;
                this.ram.write8(this.HL(), this.set(7, this.HLi()));
                break;
            }
            case 255: {
                this.cycle -= 8;
                this.A = this.set(7, this.A);
            }
        }
    }

    private final int execXY(int XY) {
        this.instruction = (this.instruction << 8) + this.ram.read8opc(this.PC++);
        this.IXYd = XY + this.sign(this.ram.read8arg(this.PC)) & 0xFFFF;
        block0 : switch (this.instruction & 0xFF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 9: {
                this.cycle -= 15;
                XY = this.add16(XY, this.BC());
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 25: {
                this.cycle -= 15;
                XY = this.add16(XY, this.DE());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 33: {
                this.cycle -= 14;
                XY = this.ram.read16arg(this.PC);
                this.PC += 2;
                break;
            }
            case 34: {
                this.cycle -= 20;
                this.ram.write16(this.ram.read16arg(this.PC), XY);
                this.PC += 2;
                break;
            }
            case 35: {
                this.cycle -= 10;
                XY = XY + 1 & 0xFFFF;
                break;
            }
            case 36: 
            case 37: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 38: {
                this.cycle -= 11;
                XY = XY & 0xFF | this.ram.read8arg(this.PC++) << 8;
                break;
            }
            case 39: 
            case 40: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 41: {
                this.cycle -= 15;
                XY = this.add16(XY, XY);
                break;
            }
            case 42: {
                this.cycle -= 20;
                XY = this.ram.read16(this.ram.read16arg(this.PC));
                this.PC += 2;
                break;
            }
            case 43: {
                this.cycle -= 10;
                XY = XY - 1 & 0xFFFF;
                break;
            }
            case 44: {
                this.cycle -= 15;
                XY = this.incL16(XY);
                break;
            }
            case 45: {
                this.cycle -= 15;
                XY = this.decL16(XY);
                break;
            }
            case 46: {
                this.cycle -= 11;
                XY = XY & 0xFF00 | this.ram.read8arg(this.PC++);
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 52: {
                this.cycle -= 15;
                this.ram.write8(this.IXYd, this.inc8(this.ram.read8(this.IXYd)));
                ++this.PC;
                break;
            }
            case 53: {
                this.cycle -= 15;
                this.ram.write8(this.IXYd, this.dec8(this.ram.read8(this.IXYd)));
                ++this.PC;
                break;
            }
            case 54: {
                this.cycle -= 19;
                this.ram.write8(this.IXYd, this.ram.read8arg(this.PC + 1));
                this.PC += 2;
                break;
            }
            case 55: 
            case 56: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 57: {
                this.cycle -= 15;
                int tmp2 = XY;
                XY = XY + this.SP & 0xFFFF;
                if (XY < tmp2) {
                    this.F = this.F & 0xFD | 1;
                    break;
                }
                this.F &= 0xFD;
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 70: {
                this.cycle -= 11;
                this.B = this.ram.read8(this.IXYd);
                ++this.PC;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 76: {
                this.cycle -= 11;
                this.C = XY >> 8;
                break;
            }
            case 77: {
                this.cycle -= 11;
                this.C = XY & 0xFF;
                break;
            }
            case 78: {
                this.cycle -= 11;
                this.C = this.ram.read8(this.IXYd);
                ++this.PC;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 84: {
                this.cycle -= 11;
                this.D = XY >> 8;
                break;
            }
            case 85: {
                this.cycle -= 11;
                this.D = XY & 0xFF;
                break;
            }
            case 86: {
                this.cycle -= 11;
                this.D = this.ram.read8(this.IXYd);
                ++this.PC;
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 92: {
                this.cycle -= 11;
                this.E = XY >> 8;
                break;
            }
            case 93: {
                this.cycle -= 11;
                this.E = XY & 0xFF;
                break;
            }
            case 94: {
                this.cycle -= 11;
                this.E = this.ram.read8(this.IXYd);
                ++this.PC;
                break;
            }
            case 95: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 96: {
                this.cycle -= 11;
                XY = this.ldXYH_8(XY, this.B);
                break;
            }
            case 97: {
                this.cycle -= 11;
                XY = this.ldXYH_8(XY, this.C);
                break;
            }
            case 98: {
                this.cycle -= 11;
                XY = this.ldXYH_8(XY, this.D);
                break;
            }
            case 99: {
                this.cycle -= 11;
                XY = this.ldXYH_8(XY, this.E);
                break;
            }
            case 100: 
            case 101: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 102: {
                this.cycle -= 11;
                this.H = this.ram.read8(this.IXYd);
                ++this.PC;
                break;
            }
            case 103: {
                this.cycle -= 11;
                XY = XY & 0xFF | this.A << 8;
                break;
            }
            case 104: {
                this.cycle -= 11;
                XY = this.ldXYL_8(XY, this.B);
                break;
            }
            case 105: {
                this.cycle -= 11;
                XY = this.ldXYL_8(XY, this.C);
                break;
            }
            case 106: {
                this.cycle -= 11;
                XY = this.ldXYL_8(XY, this.D);
                break;
            }
            case 107: {
                this.cycle -= 11;
                XY = this.ldXYL_8(XY, this.E);
                break;
            }
            case 108: 
            case 109: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 110: {
                this.cycle -= 11;
                this.L = this.ram.read8(this.IXYd);
                ++this.PC;
                break;
            }
            case 111: {
                this.cycle -= 11;
                XY = XY & 0xFF00 | this.A;
                break;
            }
            case 112: {
                this.cycle -= 11;
                this.ram.write8(this.IXYd, this.B);
                ++this.PC;
                break;
            }
            case 113: {
                this.cycle -= 11;
                this.ram.write8(this.IXYd, this.C);
                ++this.PC;
                break;
            }
            case 114: {
                this.cycle -= 11;
                this.ram.write8(this.IXYd, this.D);
                ++this.PC;
                break;
            }
            case 115: {
                this.cycle -= 11;
                this.ram.write8(this.IXYd, this.E);
                ++this.PC;
                break;
            }
            case 116: {
                this.cycle -= 11;
                this.ram.write8(this.IXYd, this.H);
                ++this.PC;
                break;
            }
            case 117: {
                this.cycle -= 11;
                this.ram.write8(this.IXYd, this.L);
                ++this.PC;
                break;
            }
            case 119: {
                this.cycle -= 11;
                this.ram.write8(this.IXYd, this.A);
                ++this.PC;
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 124: {
                this.cycle -= 11;
                this.A = (XY & 0xFF00) >> 8;
                break;
            }
            case 125: {
                this.cycle -= 11;
                this.A = XY & 0xFF;
                break;
            }
            case 126: {
                this.cycle -= 11;
                this.A = this.ram.read8(this.IXYd);
                ++this.PC;
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 132: {
                this.cycle -= 11;
                this.A = this.addA_8(XY >> 8, this.A);
                break;
            }
            case 133: {
                this.cycle -= 11;
                this.A = this.addA_8(XY & 0xFF, this.A);
                break;
            }
            case 134: {
                this.cycle -= 11;
                this.A = this.addA_8(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 142: {
                this.cycle -= 11;
                this.A = this.adcA_8(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 148: {
                this.cycle -= 11;
                this.A = this.subA_8(XY >> 8, this.A);
                break;
            }
            case 149: {
                this.cycle -= 11;
                this.A = this.subA_8(XY & 0xFF, this.A);
                break;
            }
            case 150: {
                this.cycle -= 11;
                this.A = this.subA_8(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 158: {
                this.cycle -= 11;
                this.A = this.sbcA_8(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 166: {
                this.cycle -= 11;
                this.A = this.andA(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 172: {
                this.cycle -= 11;
                this.A = this.xorA(XY >> 8, this.A);
                break;
            }
            case 173: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 174: {
                this.cycle -= 11;
                this.A = this.xorA(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 182: {
                this.cycle -= 11;
                this.A = this.orA(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: {
                this.error(this.instruction, this.PPC);
                break;
            }
            case 190: {
                this.cycle -= 11;
                this.cpA_8(this.ram.read8(this.IXYd), this.A);
                ++this.PC;
                break;
            }
            case 203: {
                this.IXYd = XY + this.sign(this.ram.read8arg(this.PC++));
                this.instruction = (this.instruction << 8) + this.ram.read8(this.PC++);
                switch (this.instruction & 0xFF) {
                    case 6: {
                        this.cycle -= 15;
                        this.ram.write8(this.IXYd, this.rlc(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 14: {
                        this.cycle -= 15;
                        this.ram.write8(this.IXYd, this.rrc(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 22: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.rl(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 30: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.rr(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 38: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.sla(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 46: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.sra(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 54: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.sll(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 62: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.srl(this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: {
                        this.cycle -= 12;
                        this.bit(0, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: {
                        this.cycle -= 12;
                        this.bit(1, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: {
                        this.cycle -= 12;
                        this.bit(2, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        this.cycle -= 12;
                        this.bit(3, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: {
                        this.cycle -= 12;
                        this.bit(4, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: {
                        this.cycle -= 12;
                        this.bit(5, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: {
                        this.cycle -= 12;
                        this.bit(6, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        this.cycle -= 12;
                        this.bit(7, this.ram.read8(this.IXYd));
                        break block0;
                    }
                    case 134: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(0, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 142: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(1, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 150: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(2, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 158: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(3, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 166: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(4, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 174: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(5, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 182: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(6, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 190: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.res(7, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 198: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(0, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 206: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(1, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 214: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(2, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 222: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(3, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 230: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(4, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 238: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(5, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 246: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(6, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                    case 254: {
                        this.cycle -= 12;
                        this.ram.write8(this.IXYd, this.set(7, this.ram.read8(this.IXYd)));
                        break block0;
                    }
                }
                this.error(this.instruction, this.PPC);
                break;
            }
            case 225: {
                this.cycle -= 14;
                XY = this.pop();
                break;
            }
            case 227: {
                this.cycle -= 23;
                int tmp1 = this.ram.read16(this.SP);
                this.ram.write16(this.SP, XY);
                XY = tmp1;
                break;
            }
            case 229: {
                this.cycle -= 14;
                this.ram.write16fast(this.SP - 2, XY);
                this.SP -= 2;
                break;
            }
            case 233: {
                this.cycle -= 8;
                this.PC = XY;
                break;
            }
            case 235: {
                this.cycle -= 8;
                int tmp1 = this.DE();
                this.D = XY >> 8;
                this.E = XY & 0xFF;
                XY = tmp1;
                break;
            }
            case 249: {
                this.cycle -= 10;
                this.SP = XY;
                break;
            }
            default: {
                this.error(this.instruction, this.PPC);
            }
        }
        return XY;
    }

    private final void nop() {
        this.cycle -= 4;
    }

    private final void ld_BC_nn() {
        this.cycle -= 10;
        this.C = this.ram.read8arg(this.PC++);
        this.B = this.ram.read8arg(this.PC++);
    }

    private final void ld_BCi_A() {
        this.cycle -= 7;
        this.ram.write8(this.BC(), this.A);
    }

    private final void inc_BC() {
        this.cycle -= 6;
        this.BC(this.BC() + 1 & 0xFFFF);
    }

    private final void inc_B() {
        this.cycle -= 4;
        this.B = this.inc8(this.B);
    }

    private final void dec_B() {
        this.cycle -= 4;
        this.B = this.dec8(this.B);
    }

    private final void ld_B_n() {
        this.cycle -= 7;
        this.B = this.ram.read8arg(this.PC++);
    }

    private final void rlca() {
        this.cycle -= 4;
        this.A = this.rlc_A(this.A);
    }

    private final void ex_AF_AF() {
        this.cycle -= 4;
        this.tmp = this.A;
        this.A = this.A1;
        this.A1 = this.tmp;
        this.tmp = this.F;
        this.F = this.F1;
        this.F1 = this.tmp;
    }

    private final void add_HL_BC() {
        this.cycle -= 11;
        this.HL(this.add16(this.HL(), this.BC()));
    }

    private final void ld_A_BCi() {
        this.cycle -= 7;
        this.A = this.ram.read8(this.BC());
    }

    private final void dec_BC() {
        this.cycle -= 6;
        this.BC(this.BC() - 1 & 0xFFFF);
    }

    private final void inc_C() {
        this.cycle -= 4;
        this.C = this.inc8(this.C);
    }

    private final void dec_C() {
        this.cycle -= 4;
        this.C = this.dec8(this.C);
    }

    private final void ld_C_n() {
        this.cycle -= 7;
        this.C = this.ram.read8arg(this.PC++);
    }

    private final void rrca() {
        this.cycle -= 4;
        this.A = this.rrc_A(this.A);
    }

    private final void djnz_n() {
        this.B = this.B - 1 & 0xFF;
        if (this.B != 0) {
            this.cycle -= 13;
            this.PC += this.sign(this.ram.read8arg(this.PC));
            ++this.PC;
        } else {
            this.cycle -= 8;
            ++this.PC;
        }
    }

    private final void ld_DE_nn() {
        this.cycle -= 10;
        this.E = this.ram.read8arg(this.PC++);
        this.D = this.ram.read8arg(this.PC++);
    }

    private final void ld_DEi_A() {
        this.cycle -= 7;
        this.ram.write8(this.DE(), this.A);
    }

    private final void inc_DE() {
        this.cycle -= 6;
        this.DE(this.DE() + 1 & 0xFFFF);
    }

    private final void inc_D() {
        this.cycle -= 4;
        this.D = this.inc8(this.D);
    }

    private final void dec_D() {
        this.cycle -= 4;
        this.D = this.dec8(this.D);
    }

    private final void ld_D_n() {
        this.cycle -= 7;
        this.D = this.ram.read8arg(this.PC++);
    }

    private final void rla() {
        this.cycle -= 4;
        this.A = this.rl_A(this.A);
    }

    private final void jr_e() {
        this.cycle -= 12;
        this.PC += this.sign(this.ram.read8arg(this.PC));
        ++this.PC;
    }

    private final void add_HL_DE() {
        this.cycle -= 11;
        this.HL(this.add16(this.HL(), this.DE()));
    }

    private final void ld_A_DEi() {
        this.cycle -= 7;
        this.A = this.ram.read8(this.DE());
    }

    private final void dec_DE() {
        this.cycle -= 6;
        this.DE(this.DE() - 1 & 0xFFFF);
    }

    private final void inc_E() {
        this.cycle -= 4;
        this.E = this.inc8(this.E);
    }

    private final void dec_E() {
        this.cycle -= 4;
        this.E = this.dec8(this.E);
    }

    private final void ld_E_n() {
        this.cycle -= 7;
        this.E = this.ram.read8arg(this.PC++);
    }

    private final void rra() {
        this.cycle -= 4;
        this.A = this.rr_A(this.A);
    }

    private final void jr_NZ_e() {
        if ((this.F & 0x40) == 0) {
            this.cycle -= 12;
            this.PC += this.sign(this.ram.read8arg(this.PC));
            ++this.PC;
        } else {
            ++this.PC;
            this.cycle -= 7;
        }
    }

    private final void ld_HL_nn() {
        this.cycle -= 10;
        this.L = this.ram.read8arg(this.PC++);
        this.H = this.ram.read8arg(this.PC++);
    }

    private final void ld_ni_HL() {
        this.cycle -= 16;
        this.ld_ea_ind16(this.HL());
    }

    private final void inc_HL() {
        this.cycle -= 6;
        this.HL(this.HL() + 1 & 0xFFFF);
    }

    private final void inc_H() {
        this.cycle -= 4;
        this.H = this.inc8(this.H);
    }

    private final void dec_H() {
        this.cycle -= 4;
        this.H = this.dec8(this.H);
    }

    private final void ld_H_n() {
        this.cycle -= 7;
        this.H = this.ram.read8arg(this.PC++);
    }

    private final void daa() {
        this.cycle -= 4;
        this.tmp1 = this.A;
        this.tmp2 = 0;
        int tmp = this.tmp3 = this.F & 1;
        if ((this.F & 0x10) != 0 || (this.tmp1 & 0xF) > 9) {
            this.tmp2 |= 6;
        }
        if (this.tmp3 == 1 || this.tmp1 > 159 || this.tmp1 > 143 && (this.tmp1 & 0xF) > 9) {
            this.tmp2 |= 0x60;
            tmp = 1;
        }
        if (this.tmp1 > 153) {
            tmp = 1;
        }
        if ((this.F & 2) != 0) {
            this.cycle -= 4;
            this.A = this.subA_8(this.tmp2, this.A);
        } else {
            this.cycle -= 4;
            this.A = this.addA_8(this.tmp2, this.A);
        }
        this.F = this.F & 0xFE | tmp;
        this.F = parity[this.A] ? this.F & 0xFB | 4 : (this.F &= 0xFB);
    }

    private final void jr_Z_e() {
        if ((this.F & 0x40) != 0) {
            this.cycle -= 12;
            this.PC += this.sign(this.ram.read8arg(this.PC));
            ++this.PC;
        } else {
            ++this.PC;
            this.cycle -= 7;
        }
    }

    private final void add_HL_HL() {
        this.cycle -= 11;
        int hl = this.HL();
        this.HL(this.add16(hl, hl));
    }

    private final void ld_HL_ni() {
        this.cycle -= 16;
        int ea = this.ram.read16arg(this.PC);
        this.H = this.ram.read8(ea + 1);
        this.L = this.ram.read8(ea);
        this.PC += 2;
    }

    private final void dec_HL() {
        this.cycle -= 6;
        this.HL(this.HL() - 1 & 0xFFFF);
    }

    private final void inc_L() {
        this.cycle -= 4;
        this.L = this.inc8(this.L);
    }

    private final void dec_L() {
        this.cycle -= 4;
        this.L = this.dec8(this.L);
    }

    private final void ld_L_n() {
        this.cycle -= 7;
        this.L = this.ram.read8arg(this.PC++);
    }

    private final void cpl() {
        this.cycle -= 4;
        this.A ^= 0xFF;
        this.F = this.F & 0xC5 | 0x12 | this.A & 0x28;
    }

    private final void jr_NC_e() {
        if ((this.F & 1) == 0) {
            this.cycle -= 12;
            this.PC += this.sign(this.ram.read8arg(this.PC));
            ++this.PC;
        } else {
            ++this.PC;
            this.cycle -= 7;
        }
    }

    private final void ld_SP_nn() {
        this.cycle -= 10;
        this.SP = this.ram.read16arg(this.PC);
        this.PC += 2;
    }

    private final void ld_ni_A() {
        this.cycle -= 13;
        this.ld_ea_ind8(this.A);
    }

    private final void inc_SP() {
        this.cycle -= 6;
        this.SP = this.SP + 1 & 0xFFFF;
    }

    private final void inc_HLi() {
        this.cycle -= 11;
        int hl = this.HL();
        this.ram.write8(hl, this.inc8(this.ram.read8(hl)));
    }

    private final void dec_HLi() {
        this.cycle -= 11;
        int hl = this.HL();
        this.ram.write8(hl, this.dec8(this.ram.read8(hl)));
    }

    private final void ld_HLi_n() {
        this.cycle -= 10;
        this.ram.write8(this.HL(), this.ram.read8arg(this.PC++));
    }

    private final void scf() {
        this.cycle -= 4;
        this.F = this.F & 0xC4 | 1 | this.A & 0x28;
    }

    private final void jr_C_e() {
        if ((this.F & 1) != 0) {
            this.cycle -= 12;
            this.PC += this.sign(this.ram.read8arg(this.PC));
            ++this.PC;
        } else {
            ++this.PC;
            this.cycle -= 7;
        }
    }

    private final void add_HL_SP() {
        this.cycle -= 11;
        this.HL(this.add16(this.HL(), this.SP));
    }

    private final void ld_A_ni() {
        this.cycle -= 13;
        this.A = this.ram.read8(this.ram.read16arg(this.PC));
        this.PC += 2;
    }

    private final void dec_SP() {
        this.cycle -= 6;
        this.SP = this.SP - 1 & 0xFFFF;
    }

    private final void inc_A() {
        this.cycle -= 4;
        this.A = this.inc8(this.A);
    }

    private final void dec_A() {
        this.cycle -= 4;
        this.A = this.dec8(this.A);
    }

    private final void ld_A_n() {
        this.cycle -= 7;
        this.A = this.ram.read8arg(this.PC++);
    }

    private final void ccf() {
        this.cycle -= 4;
        this.F = (this.F & 0xC5 | (this.F & 1) << 4 | this.A & 0x28) ^ 1;
    }

    private final void halt() {
        this.cycle -= 4;
        this.state_HALT = true;
        this.goingToirq = false;
        --this.PC;
        this.cycle = 0;
    }

    private final void ret_NZ() {
        if ((this.F & 0x40) == 0) {
            this.cycle -= 11;
            this.PC = this.pop();
        } else {
            this.cycle -= 5;
        }
    }

    private final void pop_BC() {
        this.cycle -= 10;
        this.C = this.ram.read8(this.SP++);
        this.B = this.ram.read8(this.SP++);
    }

    private final void jp_NZ_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 0x40) == 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void jp_nn() {
        this.cycle -= 10;
        this.PC = this.ram.read16arg(this.PC);
    }

    private final void call_NZ_nn() {
        if ((this.F & 0x40) == 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void push_BC() {
        this.cycle -= 11;
        this.push(this.BC());
    }

    private final void add_A_n() {
        this.cycle -= 7;
        this.A = this.addA_8(this.ram.read8arg(this.PC++), this.A);
    }

    private final void ret_Z() {
        if ((this.F & 0x40) != 0) {
            this.cycle -= 11;
            this.PC = this.pop();
        } else {
            this.cycle -= 5;
        }
    }

    private final void ret() {
        this.cycle -= 10;
        this.PC = this.pop();
    }

    private final void jp_Z_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 0x40) != 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void call_Z_nn() {
        if ((this.F & 0x40) != 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void call_nn() {
        this.cycle -= 17;
        this.push(this.PC + 2);
        this.PC = this.ram.read16arg(this.PC);
    }

    private final void adc_A_n() {
        this.cycle -= 7;
        this.A = this.adcA_8(this.ram.read8arg(this.PC++), this.A);
    }

    private final void ret_NC() {
        if ((this.F & 1) == 0) {
            this.cycle -= 11;
            this.PC = this.pop();
        } else {
            this.cycle -= 5;
        }
    }

    private final void pop_DE() {
        this.cycle -= 10;
        this.E = this.ram.read8(this.SP++);
        this.D = this.ram.read8(this.SP++);
    }

    private final void jp_NC_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 1) == 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void out_n_A() {
        this.cycle -= 11;
        this.out(this.ram.read8arg(this.PC++), this.A);
    }

    private final void call_NC_nn() {
        if ((this.F & 1) == 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void push_DE() {
        this.cycle -= 11;
        this.push(this.DE());
    }

    private final void sub_A_n() {
        this.cycle -= 7;
        this.A = this.subA_8(this.ram.read8arg(this.PC++), this.A);
    }

    private final void ret_C() {
        if ((this.F & 1) != 0) {
            this.cycle -= 11;
            this.PC = this.pop();
        } else {
            this.cycle -= 5;
        }
    }

    private final void exx() {
        this.cycle -= 4;
        this.tmp = this.B;
        this.B = this.B1;
        this.B1 = this.tmp;
        this.tmp = this.C;
        this.C = this.C1;
        this.C1 = this.tmp;
        this.tmp = this.D;
        this.D = this.D1;
        this.D1 = this.tmp;
        this.tmp = this.E;
        this.E = this.E1;
        this.E1 = this.tmp;
        this.tmp = this.H;
        this.H = this.H1;
        this.H1 = this.tmp;
        this.tmp = this.L;
        this.L = this.L1;
        this.L1 = this.tmp;
    }

    private final void jp_C_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 1) != 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void in_A_n() {
        this.cycle -= 11;
        this.A = this.in(this.ram.read8arg(this.PC++), this.A);
    }

    private final void call_C_nn() {
        if ((this.F & 1) != 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void sbc_A_n() {
        this.cycle -= 7;
        this.A = this.sbcA_8(this.ram.read8arg(this.PC++), this.A);
    }

    private final void ret_PO() {
        if ((this.F & 4) == 0) {
            this.cycle -= 11;
            this.PC = this.ram.read16(this.SP);
            this.SP += 2;
        } else {
            this.cycle -= 5;
        }
    }

    private final void pop_HL() {
        this.cycle -= 10;
        this.L = this.ram.read8(this.SP++);
        this.H = this.ram.read8(this.SP++);
    }

    private final void jp_PO_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 4) == 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void ex_SPi_HL() {
        this.cycle -= 19;
        this.tmp = this.ram.read8(this.SP + 1);
        this.ram.write8fast(this.SP + 1, this.H);
        this.H = this.tmp;
        this.tmp = this.ram.read8(this.SP);
        this.ram.write8fast(this.SP, this.L);
        this.L = this.tmp;
    }

    private final void call_PO_nn() {
        if ((this.F & 4) == 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void push_HL() {
        this.cycle -= 11;
        this.push(this.HL());
    }

    private final void and_A_n() {
        this.cycle -= 7;
        this.A = this.andA(this.ram.read8arg(this.PC++), this.A);
    }

    private final void ret_PE() {
        if ((this.F & 4) != 0) {
            this.cycle -= 11;
            this.PC = this.pop();
        } else {
            this.cycle -= 5;
        }
    }

    private final void jp_HLi() {
        this.cycle -= 4;
        this.PC = this.HL();
    }

    private final void jp_PE_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 4) != 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void ex_DE_HL() {
        this.cycle -= 4;
        this.tmp = this.D;
        this.D = this.H;
        this.H = this.tmp;
        this.tmp = this.E;
        this.E = this.L;
        this.L = this.tmp;
    }

    private final void call_PE_nn() {
        if ((this.F & 4) != 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void xor_n() {
        this.cycle -= 7;
        this.A = this.xorA(this.ram.read8arg(this.PC++), this.A);
    }

    private final void ret_P() {
        if ((this.F & 0x80) == 0) {
            this.cycle -= 11;
            this.PC = this.pop();
        } else {
            this.cycle -= 5;
        }
    }

    private final void pop_AF() {
        this.cycle -= 10;
        this.F = this.ram.read8(this.SP++);
        this.A = this.ram.read8(this.SP++);
    }

    private final void jp_P_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 0x80) == 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void di() {
        this.cycle -= 4;
        this.IFF1 = false;
        this.IFF0 = false;
    }

    private final void call_P_nn() {
        if ((this.F & 0x80) == 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void push_AF() {
        this.cycle -= 11;
        this.push(this.AF());
    }

    private final void or_n() {
        this.cycle -= 7;
        this.A = this.orA(this.ram.read8arg(this.PC++), this.A);
    }

    private final void ret_M() {
        if ((this.F & 0x80) != 0) {
            this.cycle -= 11;
            this.PC = this.pop();
        } else {
            this.cycle -= 5;
        }
    }

    private final void ld_SP_HL() {
        this.cycle -= 6;
        this.SP = this.HL();
    }

    private final void jp_M_nn() {
        this.cycle -= 10;
        this.PC = (this.F & 0x80) != 0 ? this.ram.read16arg(this.PC) : (this.PC += 2);
    }

    private final void ei() {
        this.cycle -= 4;
        this.IFF1 = true;
        this.IFF0 = true;
        this.goingToirq = true;
        this.cycle = this.checkInterrupt(this.cycle);
    }

    private final void call_M_nn() {
        if ((this.F & 0x80) != 0) {
            this.cycle -= 17;
            this.push(this.PC + 2);
            this.PC = this.ram.read16arg(this.PC);
        } else {
            this.cycle -= 10;
            this.PC += 2;
        }
    }

    private final void cp_n() {
        this.cycle -= 7;
        this.cpA_8(this.ram.read8arg(this.PC++), this.A);
    }

    private final int AF() {
        return this.A << 8 | this.F;
    }

    private final int BC() {
        return this.B << 8 | this.C;
    }

    private final int DE() {
        return this.D << 8 | this.E;
    }

    private final int HL() {
        return this.H << 8 | this.L;
    }

    private final int HLi() {
        return this.ram.read8(this.HL());
    }

    private final void AF(int nn) {
        this.A = nn >> 8;
        this.F = nn & 0xFF;
    }

    private final void BC(int nn) {
        this.B = nn >> 8;
        this.C = nn & 0xFF;
    }

    private final void DE(int nn) {
        this.D = nn >> 8;
        this.E = nn & 0xFF;
    }

    private final void HL(int nn) {
        this.H = nn >> 8;
        this.L = nn & 0xFF;
    }

    private final void push(int nn) {
        this.SP = this.SP - 2 & 0xFFFF;
        this.ram.write16fast(this.SP, nn);
    }

    private final int pop() {
        int nn = this.ram.read16arg(this.SP);
        this.SP = this.SP + 2 & 0xFFFF;
        return nn;
    }

    private final int sign(int nn) {
        return nn - ((nn & 0x80) << 1);
    }

    private final void rst(int ea) {
        this.cycle -= 11;
        this.push(this.PC);
        this.PC = ea;
    }

    private final void ld_A(int n, int cycles) {
        this.cycle -= cycles;
        this.A = n;
    }

    private final void ld_B(int n, int cycles) {
        this.cycle -= cycles;
        this.B = n;
    }

    private final void ld_C(int n, int cycles) {
        this.cycle -= cycles;
        this.C = n;
    }

    private final void ld_D(int n, int cycles) {
        this.cycle -= cycles;
        this.D = n;
    }

    private final void ld_E(int n, int cycles) {
        this.cycle -= cycles;
        this.E = n;
    }

    private final void ld_H(int n, int cycles) {
        this.cycle -= cycles;
        this.H = n;
    }

    private final void ld_L(int n, int cycles) {
        this.cycle -= cycles;
        this.L = n;
    }

    private final void ld_HLi(int n, int cycles) {
        this.cycle -= cycles;
        this.ram.write8(this.HL(), n);
    }

    private final void ld_ea_ind16(int nn) {
        this.ram.write16(this.ram.read16arg(this.PC), nn);
        this.PC += 2;
    }

    private final void ld_ea_ind8(int n) {
        this.ram.write8(this.ram.read16arg(this.PC), n);
        this.PC += 2;
    }

    private final int addA_8(int value, int A) {
        this.tmp = A + value & 0xFF;
        this.F = SZHVC_Add[A << 8 | this.tmp];
        return this.tmp;
    }

    private final void add_A(int n, int c) {
        this.cycle -= c;
        this.A = this.addA_8(n, this.A);
    }

    private final int adcA_8(int value, int A) {
        int c = this.F & 1;
        int result = A + value + c & 0xFF;
        this.F = SZHVC_Add[c << 16 | A << 8 | result];
        return result;
    }

    private final void adc_A(int n, int c) {
        this.cycle -= c;
        this.A = this.adcA_8(n, this.A);
    }

    private final int inc8(int value) {
        value = value + 1 & 0xFF;
        this.F = this.F & 1 | SZHV_inc[value];
        return value;
    }

    private final int dec8(int value) {
        value = value - 1 & 0xFF;
        this.F = this.F & 1 | SZHV_dec[value];
        return value;
    }

    private final void cpA_8(int value, int A) {
        int result = A - value & 0xFF;
        this.F = SZHVC_sub[A << 8 | result];
    }

    private final void cp_A(int n, int c) {
        this.cycle -= c;
        this.cpA_8(n, this.A);
    }

    private final int subA_8(int value, int A) {
        int result = A - value & 0xFF;
        this.F = SZHVC_sub[A << 8 | result];
        return result;
    }

    private final void sub_A(int n, int c) {
        this.cycle -= c;
        this.A = this.subA_8(n, this.A);
    }

    private final int sbcA_8(int value, int A) {
        int c = this.F & 1;
        int result = A - value - c & 0xFF;
        this.F = SZHVC_sub[c << 16 | A << 8 | result];
        return result;
    }

    private final void sbc_A(int n, int c) {
        this.cycle -= c;
        this.A = this.sbcA_8(n, this.A);
    }

    private final int add16(int a, int b) {
        int result = a + b;
        this.F = this.F & 0xC4 | (a ^ result ^ b) >> 8 & 0x10 | result >> 16 & 1;
        return result & 0xFFFF;
    }

    private final void sbcHL(int value) {
        int result;
        int _HLD;
        this.F = (_HLD ^ result ^ value) >> 8 & 0x10 | 2 | result >> 16 & 1 | result >> 8 & 0x80 | (((result = (_HLD = this.HL()) - value - (this.F & 1)) & 0xFFFF) != 0 ? 0 : 64) | ((value ^ _HLD) & (_HLD ^ result) & 0x8000) >> 13;
        this.H = result >> 8 & 0xFF;
        this.L = result & 0xFF;
    }

    private final void adcHL(int value) {
        int result;
        int _HLD;
        this.F = (_HLD ^ result ^ value) >> 8 & 0x10 | result >> 16 & 1 | result >> 8 & 0x80 | (((result = (_HLD = this.HL()) + value + (this.F & 1)) & 0xFFFF) != 0 ? 0 : 64) | ((value ^ _HLD ^ 0x8000) & (value ^ result) & 0x8000) >> 13;
        this.H = result >> 8 & 0xFF;
        this.L = result & 0xFF;
    }

    private final int srl(int value) {
        int c = value & 1;
        value = value >> 1 & 0xFF;
        this.F = SZP[value] | c;
        return value;
    }

    private final int sla(int value) {
        int c = (value & 0x80) >> 7;
        value = value << 1 & 0xFF;
        this.F = SZP[value] | c;
        return value;
    }

    private final int sll(int value) {
        int c = (value & 0x80) >> 7;
        value = (value << 1 | 1) & 0xFF;
        this.F = SZP[value] | c;
        return value;
    }

    private final int sra(int value) {
        int c = value & 1;
        value = value >> 1 | value & 0x80;
        this.F = SZP[value] | c;
        return value;
    }

    private final int rl(int value) {
        int c = (value & 0x80) >> 7;
        value = (value << 1 | this.F & 1) & 0xFF;
        this.F = SZP[value] | c;
        return value;
    }

    private final int rl_A(int A) {
        int old = A;
        A = (A << 1 | this.F & 1) & 0xFF;
        this.F = this.F & 0xEC | old >> 7;
        return A;
    }

    private final int rr(int value) {
        int c = value & 1;
        value = (value >> 1 | this.F << 7) & 0xFF;
        this.F = SZP[value] | c;
        return value;
    }

    private final int rr_A(int A) {
        int old = A;
        A = (A >> 1 | (this.F & 1) << 7) & 0xFF;
        this.F = this.F & 0xEC | old & 1;
        return A;
    }

    private final int rlc(int value) {
        int c = (value & 0x80) >> 7;
        value = (value << 1 | value >> 7) & 0xFF;
        this.F = SZP[value] | c;
        return value;
    }

    private final int rlc_A(int A) {
        this.F = this.F & 0xEC | A >> 7;
        return (A << 1) + ((A & 0x80) >> 7) & 0xFF;
    }

    private final int rrc(int value) {
        int c = value & 1;
        value = (value >> 1 | value << 7) & 0xFF;
        this.F = SZP[value] | c;
        return value;
    }

    private final int rrc_A(int A) {
        this.F = this.F & 0xEC | A & 0x29;
        return (A >> 1) + ((A & 1) << 7) & 0xFF;
    }

    private final int rld_A(int A, int H, int L) {
        int t;
        int result = A;
        int q = t = this.ram.read8(this.HL());
        t = t << 4 | result & 0xF;
        result = result & 0xF0 | q >> 4;
        this.ram.write8(this.HL(), t & 0xFF);
        this.F = this.F & 1 | SZP[result];
        return result;
    }

    private final int rrd_A(int A, int H, int L) {
        int t;
        int result = A;
        int q = t = this.ram.read8(this.HL());
        t = t >> 4 | result << 4;
        result = result & 0xF0 | q & 0xF;
        this.ram.write8(this.HL(), t & 0xFF);
        this.F = this.F & 1 | SZP[result];
        return result;
    }

    private final void bit(int bitNumber, int value) {
        this.F = this.F & 1 | 0x10 | SZ_BIT[value & bitSet[bitNumber]];
    }

    private final int set(int bitNumber, int value) {
        return value |= bitSet[bitNumber];
    }

    private final int res(int bitNumber, int value) {
        return value &= bitRes[bitNumber];
    }

    private final int andA(int value, int A) {
        this.F = SZP[A &= value] | 0x10;
        return A;
    }

    private final void and_A(int n, int c) {
        this.cycle -= c;
        this.A = this.andA(n, this.A);
    }

    private final int orA(int value, int A) {
        this.F = SZP[A |= value];
        return A;
    }

    private final void or_A(int n, int c) {
        this.cycle -= c;
        this.A = this.orA(n, this.A);
    }

    private final int xorA(int value, int A) {
        this.F = SZP[A ^= value];
        return A;
    }

    private final void xor_A(int n, int c) {
        this.cycle -= c;
        this.A = this.xorA(n, this.A);
    }

    private final void out(int port, int value) {
        this.ram.out(port, value);
    }

    private final int in(int port, int A) {
        int in = this.ram.in(port);
        this.F = this.F & 1 | SZP[A];
        return in;
    }

    private final int incL16(int value) {
        return value & 0xFF00 | this.inc8(value & 0xFF);
    }

    private final int decL16(int value) {
        return value & 0xFF00 | this.dec8(value & 0xFF);
    }

    private final int ldXYH_8(int val16, int val8) {
        return val16 & 0xFF | val8 << 8;
    }

    private final int ldXYL_8(int val16, int val8) {
        return val16 & 0xFF00 | val8;
    }

    private int R() {
        return this.R & 0xFF;
    }

    private int checkInterrupt(int cycle) {
        if (this.NMI || this.IFF0 && this.IRQ) {
            if (this.NMI) {
                this.state_HALT = false;
                this.IFF1 = this.IFF0;
                this.IFF0 = false;
                this.NMI = false;
                this.push(this.PC);
                this.PC = 102;
                cycle -= 13;
            }
            if (this.IFF0 && this.IRQ) {
                this.state_HALT = false;
                switch (this.IM) {
                    case 0: {
                        this.IFF0 = false;
                        this.IRQ = false;
                        this.push(this.PC);
                        this.PC = this.I_Vector == 0 || this.I_Vector == 255 ? 56 : this.I_Vector;
                        cycle -= 13;
                        break;
                    }
                    case 1: {
                        this.IFF0 = false;
                        this.IRQ = false;
                        this.push(this.PC);
                        this.PC = 56;
                        cycle -= 13;
                        break;
                    }
                    case 2: {
                        this.IFF0 = false;
                        this.IRQ = false;
                        this.push(this.PC);
                        this.PC = this.ram.read16arg(this.I << 8 | this.I_Vector);
                        cycle -= 19;
                        break;
                    }
                }
            }
        }
        return cycle;
    }

    private final void error(int instruction, int address) {
        System.out.println("CPU error: illegal instruction $" + Integer.toHexString(instruction) + " at $" + Integer.toHexString(address));
    }

    private void debug(int instruction, int PPC, int A, int F, int B, int C, int D, int E, int H, int L, int SP, int IX, int IY, int I, int cycles) {
        if (PPC == debugBreakPoint) {
            debugEnabled = true;
        }
        if (debugEnabled) {
            if (this.startSlice) {
                System.out.println("*** " + this.tag + " ***");
                this.startSlice = false;
            }
            int opcgroup = instruction & 0xFF00;
            String dataLog = String.valueOf(Integer.toHexString(PPC)) + " : " + Integer.toHexString(this.ram.read8(PPC)) + "," + Integer.toHexString(this.ram.read8(PPC + 1)) + "," + Integer.toHexString(this.ram.read8(PPC + 2)) + "," + Integer.toHexString(this.ram.read8(PPC + 3)) + "    \t";
            if (instruction < 256) {
                dataLog = String.valueOf(dataLog) + Z80debug.opc1[instruction];
            } else if (opcgroup == 60672) {
                dataLog = String.valueOf(dataLog) + Z80debug.opc3[instruction & 0xFF];
            } else if (opcgroup == 51968) {
                dataLog = String.valueOf(dataLog) + Z80debug.opc2[instruction & 0xFF];
            }
            dataLog = String.valueOf(dataLog) + "   AF:" + Integer.toHexString(this.AF()) + " BC:" + Integer.toHexString(this.BC()) + " DE:" + Integer.toHexString(this.DE()) + " HL:" + Integer.toHexString(this.HL()) + " SP:" + Integer.toHexString(SP) + " IX:" + Integer.toHexString(IX) + " IY:" + Integer.toHexString(IY) + " I:" + Integer.toHexString(I) + " Cycles:" + Integer.toString(cycles);
            System.out.println(dataLog);
        }
    }
}

